/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RotaryController
extends JPanel {
    private static final long serialVersionUID = 6681532871556659546L;
    private static final double SENSITIVITY = 0.01;
    private final BoundedRangeModel model;
    private final double minAngle = 4.39822971502571;
    private final double maxAngle = -1.2566370614359172;
    private final double unitIncrement = 0.01;
    private int lastY;
    private int startX;
    private Color knobColor = Color.LIGHT_GRAY;
    private Color lineColor = Color.RED;
    private double baseValue;
    private Style style = Style.ARC;

    public RotaryController(BoundedRangeModel boundedRangeModel) {
        this.model = boundedRangeModel;
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(50, 50));
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        boundedRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RotaryController.this.repaint();
            }
        });
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    private int getModelRange() {
        return this.model.getMaximum() - this.model.getExtent() - this.model.getMinimum();
    }

    public double getFractionFromModel() {
        double d = this.model.getValue();
        return this.convertValueToFraction(d);
    }

    private double convertValueToFraction(double d) {
        return (d - (double)this.model.getMinimum()) / (double)this.getModelRange();
    }

    private void setKnobByXY(int n, int n2) {
        int n3 = this.lastY - n2;
        int n4 = this.startX - n;
        double d = (double)n4 * 0.01;
        double d2 = 0.01 * Math.pow(2.0, d);
        double d3 = (double)n3 * d2;
        int n5 = (int)Math.round(d3 * (double)this.getModelRange());
        if (n5 != 0) {
            this.model.setValue(this.model.getValue() + n5);
            this.lastY = n2;
        }
    }

    private double fractionToAngle(double d) {
        return d * -5.654866776461628 + 4.39822971502571;
    }

    private void drawLineIndicator(Graphics graphics, int n, int n2, int n3, double d, boolean bl) {
        double d2;
        int n4;
        double d3 = (double)n3 * 0.95;
        int n5 = (int)(d3 * Math.sin(d));
        int n6 = (int)(d3 * Math.cos(d));
        graphics.setColor(this.lineColor);
        graphics.drawLine(n, n2, n + n5, n2 - n6);
        if (bl && (n4 = (int)((d2 = 0.1) * d3)) > 1) {
            int n7 = n + (int)((0.99 - d2) * (double)n5) - n4;
            int n8 = n2 - (int)((0.99 - d2) * (double)n6) - n4;
            graphics.fillOval(n7, n8, n4 * 2, n4 * 2);
        }
    }

    private void drawArrowIndicator(Graphics graphics, int n, int n2, int n3, double d) {
        int n4 = (int)((double)n3 * 0.95);
        int n5 = (int)((double)n3 * 0.2);
        int[] nArray = new int[]{0, n5, 0, -n5};
        int[] nArray2 = new int[]{n4, -n4 / 2, 0, -n4 / 2};
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int i = 0; i < nArray.length; ++i) {
            int n6 = nArray[i];
            int n7 = nArray2[i];
            nArray[i] = n - (int)((double)n6 * d3 - (double)n7 * d2);
            nArray2[i] = n2 - (int)((double)n6 * d2 + (double)n7 * d3);
        }
        graphics.fillPolygon(nArray, nArray2, nArray.length);
    }

    private void drawArcIndicator(Graphics graphics, int n, int n2, int n3, double d) {
        int n4 = (int)(this.fractionToAngle(this.baseValue) * 57.29577951308232);
        double d2 = (double)n3 * 0.95;
        int n5 = n - n3;
        int n6 = n2 - n3;
        int n7 = (int)(d * 57.29577951308232);
        int n8 = (int)(d2 * Math.cos(d));
        int n9 = (int)(d2 * Math.sin(d));
        graphics.setColor(this.knobColor.darker().darker());
        graphics.fillArc(n5, n6, 2 * n3, 2 * n3, 252, -324);
        graphics.setColor(Color.ORANGE);
        graphics.fillArc(n5, n6, 2 * n3, 2 * n3, n4, n7 - n4);
        int n10 = n3 / 4;
        int n11 = (n3 - n10) * 2;
        graphics.setColor(this.knobColor);
        graphics.fillOval(n10 + n - n3, n10 + n2 - n3, n11, n11);
        graphics.setColor(this.lineColor);
        graphics.drawLine(n, n2, n + n8, n2 - n9);
    }

    public void drawIndicator(Graphics graphics, int n, int n2, int n3, double d) {
        graphics.setColor(this.isEnabled() ? this.lineColor : this.lineColor.darker());
        switch (this.style) {
            case LINE: {
                this.drawLineIndicator(graphics, n, n2, n3, d, false);
                break;
            }
            case LINEDOT: {
                this.drawLineIndicator(graphics, n, n2, n3, d, true);
                break;
            }
            case ARROW: {
                this.drawArrowIndicator(graphics, n, n2, n3, d);
                break;
            }
            case ARC: {
                this.drawArcIndicator(graphics, n, n2, n3, d);
            }
        }
    }

    public void drawKnob(Graphics graphics, int n, int n2, int n3, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = n3 * 2;
        graphics.setColor(this.knobColor.darker());
        graphics.fillOval(n - n3 + 2, n2 - n3 + 2, n4, n4);
        graphics.setColor(this.knobColor);
        graphics.fillOval(n - n3, n2 - n3, n4, n4);
        this.drawIndicator(graphics, n, n2, n3, d);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = n < n2 ? n : n2;
        int n6 = (n5 -= 4) / 2;
        double d = this.fractionToAngle(this.getFractionFromModel());
        this.drawKnob(graphics, n3, n4, n6, d);
    }

    public Color getKnobColor() {
        return this.knobColor;
    }

    public void setKnobColor(Color color) {
        this.knobColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        this.baseValue = d;
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (RotaryController.this.isEnabled()) {
                RotaryController.this.setKnobByXY(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            RotaryController.this.lastY = mouseEvent.getY();
            RotaryController.this.startX = mouseEvent.getX();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (RotaryController.this.isEnabled()) {
                RotaryController.this.setKnobByXY(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public static enum Style {
        LINE,
        LINEDOT,
        ARROW,
        ARC;

    }
}

