/*
 * Decompiled with CFR 0.152.
 */
import java.awt.MouseInfo;
import java.awt.Point;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JFrame;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.data.Table;
import processing.data.TableRow;
import processing.sound.SoundFile;

public class AbilityTimer
extends PApplet {
    final String saveFileName = "save.csv";
    PFont font12;
    PFont font24;
    SoundFile chime;
    final int memoModeWidth = 240;
    final int memoModeHeight = 320;
    final int timerModeWidth = 130;
    final int timerModeHeight = 100;
    boolean timerMode = false;
    boolean pTimerMode = true;
    int next_y = 5;
    final float[] dmmGemTimeTable = new float[]{12.0f, 20.0f, -1.0f, 12.5f, 21.0f, -1.0f, -1.0f, 18.0f, 21.0f, -1.0f, 19.0f, 22.0f, -1.0f, 20.0f, 23.0f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    final float[] nutakuGemTimeTable = new float[]{12.0f, 19.0f, -1.0f, 12.5f, 19.5f, -1.0f, -1.0f, 18.0f, 22.5f, -1.0f, 19.0f, 23.0f, -1.0f, 19.5f, 23.5f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    ArrayList<GuiItem> timerModeItems = new ArrayList();
    ArrayList<GuiItem> memoModeItems = new ArrayList();
    ArrayList<Mission> missions = new ArrayList();
    JFrame jframe;
    int pMouseX = 0;
    int pMouseY = 0;

    public void settings() {
        this.size(240, 320);
    }

    public void setup() {
        this.surface.setAlwaysOnTop(true);
        PSurfaceAWT awtSurface = (PSurfaceAWT)this.surface;
        PSurfaceAWT.SmoothCanvas smoothCanvas = (PSurfaceAWT.SmoothCanvas)awtSurface.getNative();
        this.jframe = (JFrame)smoothCanvas.getFrame();
        this.jframe.dispose();
        this.jframe.setUndecorated(true);
        this.jframe.setVisible(true);
        this.surface.setResizable(true);
        TimerDisplay tmdisp = new TimerDisplay(30, 5);
        this.timerModeItems.add(tmdisp);
        CloseButton cbutton_t = new CloseButton(110, 0);
        this.timerModeItems.add(cbutton_t);
        TimerBar tmbar = new TimerBar(180, 5, 5, tmdisp);
        this.memoModeItems.add(tmbar);
        this.font12 = this.loadFont("mplus-2p-bold-12.vlw");
        this.font24 = this.loadFont("mplus-2m-bold-24.vlw");
        this.chime = new SoundFile((PApplet)this, "chime.mp3");
        Table chkTbl = this.loadTable("save.csv", "header");
        Table itemTbl = this.loadTable("Items.csv", "header");
        ZoneId zoneid = ZoneId.of("America/Los_Angeles");
        int i = 0;
        for (TableRow itemRow : itemTbl.rows()) {
            String name;
            String kind = itemRow.getString("kind");
            if (kind.equals("mission")) {
                TableRow chkRow;
                name = itemRow.getString("name");
                int items = itemRow.getInt("value");
                int value = 0;
                if (chkTbl != null && i < chkTbl.getRowCount() && (chkRow = chkTbl.getRow(i)) != null) {
                    value = chkRow.getInt("value");
                    ++i;
                }
                Mission m = new Mission(name, items, value);
                this.memoModeItems.add(m);
                this.missions.add(m);
                continue;
            }
            if (!kind.equals("service") || !(name = itemRow.getString("name")).equals("DMM")) continue;
            zoneid = ZoneId.of("Asia/Tokyo");
        }
        WallClock wallc = new WallClock(240, 320, zoneid);
        this.memoModeItems.add(wallc);
        this.memoModeItems.add(new TimerBarLabel(tmbar));
        CloseButton closeb = new CloseButton(220, 0);
        this.memoModeItems.add(closeb);
    }

    public void draw() {
        this.background(224);
        boolean changed = this.pTimerMode ^ this.timerMode;
        this.pTimerMode = this.timerMode;
        if (this.timerMode) {
            if (changed) {
                this.jframe.setOpacity(0.5f);
                this.surface.setSize(130, 100);
            }
            int i = 0;
            while (i < this.timerModeItems.size()) {
                this.timerModeItems.get(i).render();
                ++i;
            }
        } else {
            if (changed) {
                this.jframe.setOpacity(0.75f);
                this.surface.setSize(240, 320);
            }
            int i = 0;
            while (i < this.memoModeItems.size()) {
                this.memoModeItems.get(i).render();
                ++i;
            }
        }
    }

    public void mousePressed() {
        this.pMouseX = this.mouseX;
        this.pMouseY = this.mouseY;
        if (this.timerMode) {
            int i = 0;
            while (i < this.timerModeItems.size()) {
                this.timerModeItems.get(i).press();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.memoModeItems.size()) {
                this.memoModeItems.get(i).press();
                ++i;
            }
        }
    }

    public void mouseReleased() {
    }

    public void mouseDragged() {
        Point mouse = MouseInfo.getPointerInfo().getLocation();
        this.surface.setLocation(mouse.x - this.pMouseX, mouse.y - this.pMouseY - 0);
    }

    public void exit() {
        Table tbl = new Table();
        tbl.addColumn("value");
        int i = 0;
        while (i < this.missions.size()) {
            TableRow row = tbl.addRow();
            row.setInt("value", this.missions.get(i).getValue());
            ++i;
        }
        this.saveTable(tbl, "save.csv");
        super.exit();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AbilityTimer"};
        if (passedArgs != null) {
            PApplet.main((String[])AbilityTimer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Checkbox
    implements GuiItem {
        int x;
        int y;
        boolean b;
        final int itemWidth = 20;
        final int itemHeight = 20;

        Checkbox(int _x, int _y, boolean _checked) {
            this.x = _x;
            this.y = _y;
            this.b = _checked;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            if (this.b) {
                AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.line(this.x + 2, this.y + 10, this.x + 10, this.y + 15);
                AbilityTimer.this.line(this.x + 10, this.y + 15, this.x + 17, this.y + 3);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.b = !this.b;
            }
        }

        public boolean get() {
            return this.b;
        }

        public void set() {
            this.b = true;
        }

        public void reset() {
            this.b = false;
        }

        public boolean isOver() {
            boolean rc = this.x <= AbilityTimer.this.mouseX && AbilityTimer.this.mouseX < this.x + 20 && this.y <= AbilityTimer.this.mouseY && AbilityTimer.this.mouseY < this.y + 20;
            return rc;
        }
    }

    class CloseButton
    implements GuiItem {
        int x;
        int y;
        final int itemWidth = 20;
        final int itemHeight = 20;

        CloseButton(int _x, int _y) {
            this.x = _x;
            this.y = _y;
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 16);
            AbilityTimer.this.line(this.x + 3, this.y + 16, this.x + 16, this.y + 3);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.exit();
            }
        }

        public boolean isOver() {
            boolean rc = this.x <= AbilityTimer.this.mouseX && AbilityTimer.this.mouseX < this.x + 20 && this.y <= AbilityTimer.this.mouseY && AbilityTimer.this.mouseY < this.y + 20;
            return rc;
        }
    }

    static interface GuiItem {
        public void render();

        public void press();
    }

    class Mission
    implements GuiItem {
        String name;
        Checkbox[] boxes;
        int y;
        final int delta_y = 29;

        Mission(String _name, int _items, int _value) {
            this.name = _name;
            this.boxes = new Checkbox[_items];
            this.y = AbilityTimer.this.next_y;
            AbilityTimer.this.next_y += 29;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i] = new Checkbox(115 + 25 * i, this.y, i < _value);
                ++i;
            }
        }

        @Override
        public void render() {
            boolean isCurrent = false;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i].render();
                isCurrent = isCurrent ? true : this.boxes[i].isOver();
                ++i;
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font12);
            AbilityTimer.this.textSize(12.0f);
            if (isCurrent) {
                AbilityTimer.this.fill(128);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 4.0f, this.y + 15 - 1);
            } else {
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
            }
        }

        @Override
        public void press() {
            int i = 0;
            while (i < this.boxes.length) {
                int j;
                this.boxes[i].press();
                if (this.boxes[i].get()) {
                    j = i - 1;
                    while (j >= 0) {
                        this.boxes[j].set();
                        --j;
                    }
                } else {
                    j = i + 1;
                    while (j < this.boxes.length) {
                        this.boxes[j].reset();
                        ++j;
                    }
                }
                ++i;
            }
        }

        public void release() {
        }

        public int getValue() {
            int i = this.boxes.length - 1;
            while (i >= 0) {
                if (this.boxes[i].get()) break;
                --i;
            }
            return i + 1;
        }
    }

    class TimerBar
    implements GuiItem {
        int seconds;
        int x;
        int y;
        TimerDisplay td;
        final int itemWidth = 64;
        final int itemHeight = 310;

        TimerBar(int _seconds, int _x, int _y, TimerDisplay _td) {
            this.seconds = _seconds;
            this.x = _x;
            this.y = _y;
            this.td = _td;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(224);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.triangle(this.x, this.y + 5, this.x, this.y + 310, this.x + 64 - 1, this.y + 310 - 1);
            AbilityTimer.this.fill(240);
            AbilityTimer.this.triangle(this.x, this.y, this.x + 64, this.y, this.x + 64 - 1, this.y + 310 - 1);
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.triangle(this.x, this.y, this.x, AbilityTimer.this.mouseY, this.x + AbilityTimer.this.mouseY / 5, AbilityTimer.this.mouseY);
            }
        }

        public int computeSeconds() {
            int pos = AbilityTimer.this.mouseY / 2;
            if (pos >= 50) {
                pos = 50 + (pos - 50) / 4 * 5;
            }
            return pos;
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.td.start(this.computeSeconds());
            }
        }

        public boolean isOver() {
            boolean rc = this.x <= AbilityTimer.this.mouseX && AbilityTimer.this.mouseX < this.x + 64 && this.y <= AbilityTimer.this.mouseY && AbilityTimer.this.mouseY < this.y + 310;
            return rc;
        }
    }

    class TimerBarLabel
    implements GuiItem {
        TimerBar tb;

        TimerBarLabel(TimerBar _tb) {
            this.tb = _tb;
        }

        @Override
        public void render() {
            if (this.tb.isOver()) {
                String msg = String.valueOf(AbilityTimer.str((int)this.tb.computeSeconds())) + "sec";
                int y = AbilityTimer.this.mouseY;
                if (y < 20) {
                    y = 20;
                }
                AbilityTimer.this.textFont(AbilityTimer.this.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(64);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5 + 2, y + 2);
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5, y);
            }
        }

        @Override
        public void press() {
        }
    }

    class TimerDisplay
    implements GuiItem {
        int x;
        int y;
        int endTime;
        final int itemWidth = 70;
        final int itemHeight = 30;

        TimerDisplay(int _x, int _y) {
            this.x = _x;
            this.y = _y;
            this.endTime = 0;
        }

        public void start(int seconds) {
            this.endTime = AbilityTimer.this.millis() + 1000 * seconds;
            AbilityTimer.this.timerMode = true;
        }

        @Override
        public void render() {
            int currentTime = AbilityTimer.this.millis();
            int remainTime = this.endTime - currentTime;
            if (remainTime <= 0) {
                AbilityTimer.this.timerMode = false;
                AbilityTimer.this.chime.play();
            } else {
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.stroke(128);
                AbilityTimer.this.fill(this.isOver() ? 64 : 0);
                AbilityTimer.this.rect(this.x, this.y, 69.0f, 29.0f);
                String msg = "000.0";
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                int sec = remainTime / 1000;
                int decimal = remainTime / 100 % 10;
                String zeros = "";
                if (sec < 10) {
                    zeros = "00";
                } else if (sec < 100) {
                    zeros = "0";
                }
                msg = String.valueOf(zeros) + AbilityTimer.str((int)sec) + "." + AbilityTimer.str((int)decimal);
                AbilityTimer.this.textFont(AbilityTimer.this.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.text(msg, this.x + 5, this.y + 22);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.timerMode = false;
            }
        }

        public boolean isOver() {
            boolean rc = this.x <= AbilityTimer.this.mouseX && AbilityTimer.this.mouseX < this.x + 70 && this.y <= AbilityTimer.this.mouseY && AbilityTimer.this.mouseY < this.y + 30;
            return rc;
        }
    }

    class WallClock
    implements GuiItem {
        int x;
        int y;
        final int itemWidth = 82;
        final int itemHeight = 20;
        ZoneId zid;
        int[] gemTimeTable;

        WallClock(int _x, int _y, ZoneId _zid) {
            this.x = _x - 82 - 1;
            this.y = _y - 20 - 1;
            this.zid = _zid;
            this.gemTimeTable = new int[AbilityTimer.this.dmmGemTimeTable.length];
            float[] tbl = AbilityTimer.this.dmmGemTimeTable;
            if (this.zid.equals(ZoneId.of("America/Los_Angeles"))) {
                tbl = AbilityTimer.this.nutakuGemTimeTable;
            }
            int i = 0;
            while (i < AbilityTimer.this.dmmGemTimeTable.length) {
                this.gemTimeTable[i] = PApplet.parseInt((float)(tbl[i] * 100.0f));
                ++i;
            }
        }

        @Override
        public void render() {
            Instant currentTime = Instant.now();
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int w = zoneTime.getDayOfWeek().getValue();
            int hour = zoneTime.getHour();
            int minute = zoneTime.getMinute();
            boolean isGemTime = false;
            int nowHour = hour * 100 + minute * 100 / 60;
            int i = 0;
            while (i < 3) {
                int gemHour = this.gemTimeTable[(w - 1) * 3 + i];
                if (gemHour <= nowHour && nowHour < gemHour + 50) {
                    isGemTime = true;
                    break;
                }
                ++i;
            }
            if (this.isOver()) {
                zoneTime = currentTime.atZone(ZoneId.systemDefault());
                hour = zoneTime.getHour();
                minute = zoneTime.getMinute();
            }
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.stroke(128);
            if (isGemTime) {
                AbilityTimer.this.fill(255.0f, 255.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.rect(this.x, this.y, 81.0f, 19.0f);
            if (isGemTime) {
                AbilityTimer.this.fill(0);
            } else {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font24);
            AbilityTimer.this.textSize(12.0f);
            String dow = zoneTime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US);
            int day = zoneTime.getDayOfMonth();
            String msg = String.valueOf(dow) + " " + (day < 10 ? " " : "") + AbilityTimer.str((int)day);
            msg = String.valueOf(msg) + " " + (hour < 10 ? "0" : "") + AbilityTimer.str((int)hour);
            msg = String.valueOf(msg) + ":" + (minute < 10 ? "0" : "") + AbilityTimer.str((int)minute);
            AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            if (this.isOver()) {
                this.putGemQuestTable(currentTime);
            } else {
                AbilityTimer.this.textFont(AbilityTimer.this.font12);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textAlign(39);
                AbilityTimer.this.text(this.zid.toString(), this.x - 2, 312.0f);
                AbilityTimer.this.textAlign(37);
            }
        }

        @Override
        public void press() {
        }

        public boolean isOver() {
            boolean rc = this.x <= AbilityTimer.this.mouseX && AbilityTimer.this.mouseX < this.x + 82 && this.y <= AbilityTimer.this.mouseY && AbilityTimer.this.mouseY < this.y + 20;
            return rc;
        }

        public void putGemQuestTable(Instant currentTime) {
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int m = zoneTime.getMinute();
            if (m % 15 > 0) {
                zoneTime = zoneTime.plusMinutes(15 - m % 15);
            }
            AbilityTimer.this.stroke(128);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.rect(6.0f, 86.0f, 231.0f, 201.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.rect(5.0f, 85.0f, 230.0f, 200.0f);
            int msgY = 100;
            boolean first = true;
            int[] localGemTimeTable = new int[28];
            int i = 0;
            while (i < 28) {
                localGemTimeTable[i] = Integer.MAX_VALUE;
                ++i;
            }
            i = 0;
            while (i < 672) {
                int w = zoneTime.getDayOfWeek().getValue();
                int hour = zoneTime.getHour();
                int minute = zoneTime.getMinute();
                int nowHour = hour * 100 + minute * 100 / 60;
                int j = 0;
                while (j < 3) {
                    int gemHour = this.gemTimeTable[(w - 1) * 3 + j];
                    if (gemHour == nowHour) {
                        Instant t = Instant.from(zoneTime);
                        ZonedDateTime local = t.atZone(ZoneId.systemDefault());
                        int lw = local.getDayOfWeek().getValue();
                        int lh = local.getHour();
                        int lm = local.getMinute();
                        int found = lh * 100 + lm * 100 / 60;
                        if (first) {
                            first = false;
                        }
                        int index = (lw - 1) * 4;
                        int[] part = new int[]{++found, localGemTimeTable[index + 0], localGemTimeTable[index + 1], localGemTimeTable[index + 2], localGemTimeTable[index + 3]};
                        Arrays.sort(part);
                        System.arraycopy(part, 0, localGemTimeTable, index, 4);
                    }
                    ++j;
                }
                zoneTime = zoneTime.plusMinutes(15L);
                ++i;
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Gem Quest on your Timezone", 10.0f, msgY);
            msgY = (int)((float)msgY + 30.0f);
            int w = 1;
            while (w <= 7) {
                String msg = DayOfWeek.of(w).getDisplayName(TextStyle.SHORT, Locale.US);
                msg = String.valueOf(msg) + " ";
                int i2 = 0;
                while (i2 < 4) {
                    int index = (w - 1) * 4 + i2;
                    int value = localGemTimeTable[index];
                    if (value != Integer.MAX_VALUE) {
                        int lh = value / 100;
                        int lm = value % 100 * 60 / 100;
                        if (value % 10 == 1) {
                            msg = String.valueOf(msg) + ">" + (lh < 10 ? "0" : "") + AbilityTimer.str((int)lh);
                            msg = String.valueOf(msg) + ":" + (lm < 10 ? "0" : "") + AbilityTimer.str((int)lm) + "<";
                        } else {
                            msg = String.valueOf(msg) + " " + (lh < 10 ? "0" : "") + AbilityTimer.str((int)lh);
                            msg = String.valueOf(msg) + ":" + (lm < 10 ? "0" : "") + AbilityTimer.str((int)lm) + " ";
                        }
                    }
                    ++i2;
                }
                AbilityTimer.this.textFont(AbilityTimer.this.font24);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(msg, 15.0f, msgY);
                msgY += 20;
                ++w;
            }
            AbilityTimer.this.textFont(AbilityTimer.this.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(ZoneId.systemDefault().toString(), this.x - 55, this.y - 20);
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x - 10, this.y - 15, this.x, this.y - 3);
        }
    }
}

