/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource.locator;

import java.util.Arrays;
import java.util.Iterator;

public class ExtensionResourceNameIterator
implements Iterator<String> {
    private static final Iterable<String> NULL_ITERABLE = Arrays.asList(new String[]{null});
    private final Iterator<String> iterator;
    private String current;

    public ExtensionResourceNameIterator(Iterable<String> extensions) {
        this.iterator = extensions == null || !extensions.iterator().hasNext() ? NULL_ITERABLE.iterator() : extensions.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public String next() {
        this.current = this.iterator.next();
        return this.getExtension();
    }

    public final String getExtension() {
        String ext = this.current;
        if (ext != null && ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        return ext;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

