/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.IOException;
import org.apache.wicket.request.resource.IResourceUrlSanitizer;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResourceUrlSanitizer
implements IResourceUrlSanitizer {
    private static final Logger log = LoggerFactory.getLogger(PackageResourceUrlSanitizer.class);

    @Override
    public ResourceReference.UrlAttributes sanitize(ResourceReference.UrlAttributes urlAttributes, Class<?> scope, String name) {
        IResourceStream filesystemMatch = PackageResource.getResourceStream(scope, name, urlAttributes.getLocale(), urlAttributes.getStyle(), urlAttributes.getVariation(), false);
        if (filesystemMatch == null) {
            return null;
        }
        try {
            filesystemMatch.close();
        }
        catch (IOException e) {
            log.error("failed to close", e);
        }
        return new ResourceReference.UrlAttributes(filesystemMatch.getLocale(), filesystemMatch.getStyle(), filesystemMatch.getVariation());
    }
}

