/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class ImageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence createBase64EncodedImage(PackageResourceReference imageReference, boolean removeWhitespaces) throws ResourceStreamNotFoundException, IOException {
        IResourceStream resourceStream = imageReference.getResource().getResourceStream();
        InputStream inputStream = resourceStream.getInputStream();
        try {
            byte[] bytes = IOUtils.toByteArray(inputStream);
            String base64EncodedImage = Base64.getEncoder().encodeToString(bytes);
            String string = "data:" + resourceStream.getContentType() + ";base64," + (removeWhitespaces ? base64EncodedImage.replaceAll("\\s", "") : base64EncodedImage);
            return string;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

