/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.openjpa.lib.util.SizedMap;
import org.apache.openjpa.lib.util.collections.AbstractLinkedMap;

public class LRUMap
extends org.apache.openjpa.lib.util.collections.LRUMap
implements SizedMap {
    private static final long serialVersionUID = 1L;
    private int _max = -1;

    public LRUMap() {
    }

    public LRUMap(int initCapacity) {
        super(initCapacity);
    }

    public LRUMap(int initCapacity, float loadFactor) {
        super(initCapacity, loadFactor);
    }

    public LRUMap(Map map) {
        super(map);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize();
    }

    @Override
    public void setMaxSize(int max) {
        if (max < 0) {
            throw new IllegalArgumentException(String.valueOf(max));
        }
        this._max = max;
        while (this.size() > this._max) {
            Object key = this.lastKey();
            this.overflowRemoved(key, this.remove(key));
        }
    }

    @Override
    public void overflowRemoved(Object key, Object value) {
    }

    @Override
    public int maxSize() {
        return this._max == -1 ? super.maxSize() : this._max;
    }

    @Override
    public boolean isFull() {
        return this._max == -1 ? super.isFull() : this.size() >= this._max;
    }

    protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
        this.overflowRemoved(entry.getKey(), entry.getValue());
        return super.removeLRU(entry);
    }

    @Override
    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._max);
        super.doWriteObject(out);
    }

    @Override
    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._max = in.readInt();
        super.doReadObject(in);
    }
}

