/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.deser.jdk.DateBasedDeserializer;
import tools.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class JavaUtilCalendarDeserializer
extends DateBasedDeserializer<Calendar> {
    protected final Constructor<Calendar> _defaultCtor;

    public JavaUtilCalendarDeserializer() {
        super(Calendar.class);
        this._defaultCtor = null;
    }

    public JavaUtilCalendarDeserializer(Class<? extends Calendar> cc) {
        super(cc);
        this._defaultCtor = ClassUtil.findConstructor(cc, false);
    }

    public JavaUtilCalendarDeserializer(JavaUtilCalendarDeserializer src, DateFormat df, String formatString) {
        super(src, df, formatString);
        this._defaultCtor = src._defaultCtor;
    }

    protected JavaUtilCalendarDeserializer withDateFormat(DateFormat df, String formatString) {
        return new JavaUtilCalendarDeserializer(this, df, formatString);
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(0L);
        return cal;
    }

    @Override
    public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Date d = this._parseDate(p, ctxt);
        if (d == null) {
            return null;
        }
        if (this._defaultCtor == null) {
            return ctxt.constructCalendar(d);
        }
        try {
            Calendar c = this._defaultCtor.newInstance(new Object[0]);
            c.setTimeInMillis(d.getTime());
            TimeZone tz = ctxt.getTimeZone();
            if (tz != null) {
                c.setTimeZone(tz);
            }
            return c;
        }
        catch (Exception e) {
            return (Calendar)ctxt.handleInstantiationProblem(this.handledType(), d, e);
        }
    }
}

