/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;
import org.apache.derby.shared.common.i18n.MessageService;

public abstract class JNDIAuthenticationSchemeBase
implements UserAuthenticator {
    protected final JNDIAuthenticationService authenticationService;
    protected String providerURL;
    private AccessFactory store;
    protected Properties initDirContextEnv;

    public JNDIAuthenticationSchemeBase(JNDIAuthenticationService jNDIAuthenticationService, Properties properties) {
        this.authenticationService = jNDIAuthenticationService;
        this.setInitDirContextEnv(properties);
        this.setJNDIProviderProperties();
    }

    protected abstract void setJNDIProviderProperties();

    private void setInitDirContextEnv(Properties properties) {
        this.initDirContextEnv = new Properties();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("java.naming.")) continue;
                this.initDirContextEnv.put(string, properties.getProperty(string));
            }
        }
    }

    protected static final SQLException getLoginSQLException(Exception exception) {
        String string = MessageService.getTextMessage((String)"08004", (Object[])new Object[]{exception});
        SQLException sQLException = new SQLException(string, "08004", 40000);
        return sQLException;
    }
}

