/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostalias;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.qpid.server.model.HostNameAlias;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.virtualhostalias.AbstractFixedVirtualHostNodeAlias;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostNameAliasImpl
extends AbstractFixedVirtualHostNodeAlias<HostNameAliasImpl>
implements HostNameAlias<HostNameAliasImpl> {
    private static final Logger LOG = LoggerFactory.getLogger(HostNameAliasImpl.class);
    private final Set<InetAddress> _localAddresses = new CopyOnWriteArraySet<InetAddress>();
    private final Set<String> _localAddressNames = new CopyOnWriteArraySet<String>();
    private final Lock _addressLock = new ReentrantLock();
    private final AtomicBoolean _addressesComputed = new AtomicBoolean();

    @ManagedObjectFactoryConstructor
    protected HostNameAliasImpl(Map<String, Object> attributes, Port port) {
        super(attributes, port);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        String bindingAddress = this.getPort().getBindingAddress();
        Thread thread = new Thread((Runnable)new NetworkAddressResolver(), "Network Address Resolver (Port: " + (this.useAllAddresses(bindingAddress) ? "" : bindingAddress) + ":" + this.getPort().getPort() + ")");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    protected boolean matches(String host) {
        if (this._localAddressNames.contains(host)) {
            return true;
        }
        while (!this._addressesComputed.get()) {
            Lock lock = this._addressLock;
            lock.lock();
            lock.unlock();
        }
        boolean isNetworkAddress = true;
        if (!this._localAddressNames.contains(host)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(host);
                if (!this._localAddresses.contains(inetAddress)) {
                    isNetworkAddress = false;
                } else {
                    this._localAddressNames.add(host);
                }
            }
            catch (UnknownHostException e) {
                isNetworkAddress = false;
            }
        }
        return isNetworkAddress;
    }

    private boolean useAllAddresses(String bindingAddress) {
        return bindingAddress == null || bindingAddress.trim().equals("") || bindingAddress.trim().equals("*");
    }

    private static int compareAddresses(InetAddress left, InetAddress right) {
        byte[] rightBytes;
        if (left.isLoopbackAddress() != right.isLoopbackAddress()) {
            return left.isLoopbackAddress() ? -1 : 1;
        }
        if (left.isSiteLocalAddress() != right.isSiteLocalAddress()) {
            return left.isSiteLocalAddress() ? -1 : 1;
        }
        if (left.isLinkLocalAddress() != right.isLinkLocalAddress()) {
            return left.isLinkLocalAddress() ? 1 : -1;
        }
        if (left.isMulticastAddress() != right.isMulticastAddress()) {
            return left.isMulticastAddress() ? 1 : -1;
        }
        if (left instanceof Inet4Address && !(right instanceof Inet4Address)) {
            return -1;
        }
        if (right instanceof Inet4Address && !(left instanceof Inet4Address)) {
            return 1;
        }
        byte[] leftBytes = left.getAddress();
        if (leftBytes.length == (rightBytes = right.getAddress()).length) {
            for (int i = 0; i < left.getAddress().length; ++i) {
                int compare = Byte.compare(leftBytes[i], rightBytes[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        return Integer.compare(left.getAddress().length, right.getAddress().length);
    }

    private class NetworkAddressResolver
    implements Runnable {
        private NetworkAddressResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HostNameAliasImpl.this._addressesComputed.set(false);
            Lock lock = HostNameAliasImpl.this._addressLock;
            lock.lock();
            String bindingAddress = HostNameAliasImpl.this.getPort().getBindingAddress();
            try {
                Collection<InetAddress> inetAddresses = HostNameAliasImpl.this.useAllAddresses(bindingAddress) ? this.getAllInetAddresses() : Collections.singleton(InetAddress.getByName(bindingAddress));
                for (InetAddress address : inetAddresses) {
                    String canonicalHostName;
                    String hostName;
                    HostNameAliasImpl.this._localAddresses.add(address);
                    String hostAddress = address.getHostAddress();
                    if (hostAddress != null) {
                        HostNameAliasImpl.this._localAddressNames.add(hostAddress);
                    }
                    if ((hostName = address.getHostName()) != null) {
                        HostNameAliasImpl.this._localAddressNames.add(hostName);
                    }
                    if ((canonicalHostName = address.getCanonicalHostName()) == null) continue;
                    HostNameAliasImpl.this._localAddressNames.add(canonicalHostName);
                }
            }
            catch (SocketException | UnknownHostException e) {
                LOG.error("Unable to correctly calculate host name aliases for port " + HostNameAliasImpl.this.getPort().getName() + ". This may lead to connection failures.", (Throwable)e);
            }
            finally {
                HostNameAliasImpl.this._addressesComputed.set(true);
                lock.unlock();
            }
        }

        private Collection<InetAddress> getAllInetAddresses() throws SocketException {
            TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(HostNameAliasImpl::compareAddresses);
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress inetAddress : networkInterface.getInterfaceAddresses()) {
                    addresses.add(inetAddress.getAddress());
                }
            }
            return addresses;
        }
    }
}

