/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.upgrade;

import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.service.QuotaRepairTask;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OmUpgradeAction;
import org.apache.hadoop.ozone.om.upgrade.UpgradeActionOm;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionOm(type=LayoutFeature.UpgradeActionType.ON_FINALIZE, feature=OMLayoutFeature.QUOTA)
public class QuotaRepairUpgradeAction
implements OmUpgradeAction {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaRepairUpgradeAction.class);

    public void execute(OzoneManager arg) throws Exception {
        boolean enabled = arg.getConfiguration().getBoolean("ozone.om.upgrade.quota.recalculate.enabled", true);
        if (enabled) {
            try {
                arg.checkLeaderStatus();
                QuotaRepairTask quotaRepairTask = new QuotaRepairTask(arg);
                quotaRepairTask.repair();
            }
            catch (OMLeaderNotReadyException | OMNotLeaderException throwable) {
                LOG.warn("Skip quota repair operation during upgrade on the node as this is not a leader node.");
            }
        }
    }
}

