/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.validation;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ValidatorRegistry {
    private final EnumMap<ValidationCondition, EnumMap<OzoneManagerProtocolProtos.Type, EnumMap<RequestProcessingPhase, List<Method>>>> validators = new EnumMap(ValidationCondition.class);

    ValidatorRegistry(String validatorPackage) {
        this(ClasspathHelper.forPackage((String)validatorPackage, (ClassLoader[])new ClassLoader[0]));
    }

    ValidatorRegistry(Collection<URL> searchUrls) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(searchUrls).setScanners(new Scanner[]{Scanners.MethodsAnnotated}).setParallel(true));
        Set describedValidators = reflections.getMethodsAnnotatedWith(RequestFeatureValidator.class);
        this.initMaps(describedValidators);
    }

    List<Method> validationsFor(List<ValidationCondition> conditions, OzoneManagerProtocolProtos.Type requestType, RequestProcessingPhase phase) {
        if (conditions.isEmpty() || this.validators.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Method> returnValue = new HashSet<Method>();
        for (ValidationCondition condition : conditions) {
            returnValue.addAll(this.validationsFor(condition, requestType, phase));
        }
        return new ArrayList<Method>(returnValue);
    }

    private List<Method> validationsFor(ValidationCondition condition, OzoneManagerProtocolProtos.Type requestType, RequestProcessingPhase phase) {
        EnumMap<OzoneManagerProtocolProtos.Type, EnumMap<RequestProcessingPhase, List<Method>>> requestTypeMap = this.validators.get((Object)condition);
        if (requestTypeMap == null || requestTypeMap.isEmpty()) {
            return Collections.emptyList();
        }
        EnumMap<RequestProcessingPhase, List<Method>> phases = requestTypeMap.get(requestType);
        if (phases == null) {
            return Collections.emptyList();
        }
        List<Method> validatorsForPhase = phases.get(phase);
        if (validatorsForPhase == null) {
            return Collections.emptyList();
        }
        return validatorsForPhase;
    }

    void initMaps(Collection<Method> describedValidators) {
        for (Method m : describedValidators) {
            RequestFeatureValidator descriptor = m.getAnnotation(RequestFeatureValidator.class);
            m.setAccessible(true);
            ValidationCondition[] validationConditionArray = descriptor.conditions();
            int n = validationConditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidationCondition condition = validationConditionArray[n2];
                EnumMap<OzoneManagerProtocolProtos.Type, EnumMap<RequestProcessingPhase, List<Method>>> requestTypeMap = this.getAndInitialize(condition, this::newTypeMap, this.validators);
                EnumMap<RequestProcessingPhase, List<Method>> phases = this.getAndInitialize(descriptor.requestType(), this::newPhaseMap, requestTypeMap);
                if (this.isPreProcessValidator(descriptor)) {
                    this.getAndInitialize(RequestProcessingPhase.PRE_PROCESS, ArrayList::new, phases).add(m);
                } else if (this.isPostProcessValidator(descriptor)) {
                    this.getAndInitialize(RequestProcessingPhase.POST_PROCESS, ArrayList::new, phases).add(m);
                }
                ++n2;
            }
        }
    }

    private EnumMap<OzoneManagerProtocolProtos.Type, EnumMap<RequestProcessingPhase, List<Method>>> newTypeMap() {
        return new EnumMap<OzoneManagerProtocolProtos.Type, EnumMap<RequestProcessingPhase, List<Method>>>(OzoneManagerProtocolProtos.Type.class);
    }

    private EnumMap<RequestProcessingPhase, List<Method>> newPhaseMap() {
        return new EnumMap<RequestProcessingPhase, List<Method>>(RequestProcessingPhase.class);
    }

    private <K, V> V getAndInitialize(K key, Supplier<V> defaultSupplier, Map<K, V> from) {
        return (V)from.computeIfAbsent(key, k -> defaultSupplier.get());
    }

    private boolean isPreProcessValidator(RequestFeatureValidator descriptor) {
        return descriptor.processingPhase().equals((Object)RequestProcessingPhase.PRE_PROCESS);
    }

    private boolean isPostProcessValidator(RequestFeatureValidator descriptor) {
        return descriptor.processingPhase().equals((Object)RequestProcessingPhase.POST_PROCESS);
    }
}

