/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.util;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.util.UUIDv7;

public final class OMMultipartUploadUtils {
    private OMMultipartUploadUtils() {
    }

    public static String getMultipartUploadId() {
        return UUIDv7.randomUUID() + "-" + UniqueId.next();
    }

    public static String getUploadIdFromDbKey(String key) {
        String[] split = key.split("/");
        if (split.length < 5) {
            return null;
        }
        String uploadId = split[split.length - 1];
        if (StringUtils.isEmpty((CharSequence)uploadId) || uploadId.split("-").length != 6) {
            return null;
        }
        return uploadId;
    }

    public static String getMultipartOpenKey(String volumeName, String bucketName, String keyName, String multipartUploadId, OMMetadataManager omMetadataManager, BucketLayout bucketLayout) throws IOException {
        if (bucketLayout == BucketLayout.FILE_SYSTEM_OPTIMIZED) {
            return omMetadataManager.getMultipartKeyFSO(volumeName, bucketName, keyName, multipartUploadId);
        }
        return omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, multipartUploadId);
    }

    public static boolean isMultipartKeySet(OmKeyInfo openKeyInfo) {
        return openKeyInfo.getLatestVersionLocations() != null && openKeyInfo.getLatestVersionLocations().isMultipartKey();
    }
}

