/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.OMSystemAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshotInternalMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotPurgeResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMSnapshotPurgeRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMSnapshotPurgeRequest.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMSYSTEMLOGGER);
    private static final String AUDIT_PARAM_SNAPSHOT_DB_KEYS = "snapshotsDBKeys";
    private static final String AUDIT_PARAM_SNAPSHOTS_SET_FOR_DEEP_CLEAN = "snapshotsSetForDeepClean";
    private final Map<String, SnapshotInfo> updatedSnapshotInfos = new HashMap<String, SnapshotInfo>();

    public OMSnapshotPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMSnapshotPurgeResponse omClientResponse;
        block6: {
            OmSnapshotInternalMetrics omSnapshotIntMetrics = ozoneManager.getOmSnapshotIntMetrics();
            long trxnLogIndex = context.getIndex();
            OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
            SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
            omClientResponse = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OzoneManagerProtocolProtos.SnapshotPurgeRequest snapshotPurgeRequest = this.getOmRequest().getSnapshotPurgeRequest();
            List snapshotDbKeys = snapshotPurgeRequest.getSnapshotDBKeysList();
            try {
                for (String snapTableKey : snapshotDbKeys) {
                    SnapshotInfo fromSnapshot = this.getUpdatedSnapshotInfo(snapTableKey, omMetadataManager);
                    if (fromSnapshot == null) {
                        LOG.warn("The snapshot {} is not longer in snapshot table, It maybe removed in the previous Snapshot purge request.", (Object)snapTableKey);
                        continue;
                    }
                    SnapshotInfo nextSnapshot = SnapshotUtils.getNextSnapshot(ozoneManager, snapshotChainManager, fromSnapshot);
                    SnapshotInfo nextToNextSnapshot = nextSnapshot == null ? null : SnapshotUtils.getNextSnapshot(ozoneManager, snapshotChainManager, nextSnapshot);
                    this.updateSnapshotInfoAndCache(nextSnapshot, omMetadataManager, trxnLogIndex);
                    this.updateSnapshotInfoAndCache(nextToNextSnapshot, omMetadataManager, trxnLogIndex);
                    this.updateSnapshotChainAndCache(omMetadataManager, fromSnapshot, trxnLogIndex);
                    omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshot.getTableKey()), CacheValue.get((long)trxnLogIndex));
                    this.updatedSnapshotInfos.remove(fromSnapshot.getTableKey());
                }
                for (SnapshotInfo snapshotInfo : this.updatedSnapshotInfos.values()) {
                    snapshotInfo.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
                    omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapshotInfo.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)snapshotInfo));
                }
                omClientResponse = new OMSnapshotPurgeResponse(omResponse.build(), snapshotDbKeys, this.updatedSnapshotInfos);
                omSnapshotIntMetrics.incNumSnapshotPurges();
                LOG.info("Successfully executed snapshotPurgeRequest: {{}} along with updating snapshots:{}.", (Object)snapshotPurgeRequest, this.updatedSnapshotInfos);
                if (LOG.isDebugEnabled()) {
                    LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
                    auditParams.put(AUDIT_PARAM_SNAPSHOT_DB_KEYS, snapshotDbKeys.toString());
                    auditParams.put(AUDIT_PARAM_SNAPSHOTS_SET_FOR_DEEP_CLEAN, String.join((CharSequence)",", this.updatedSnapshotInfos.keySet()));
                    AUDIT.logWriteSuccess(ozoneManager.buildAuditMessageForSuccess(OMSystemAction.SNAPSHOT_PURGE, auditParams));
                }
            }
            catch (IOException ex) {
                omClientResponse = new OMSnapshotPurgeResponse(this.createErrorOMResponse(omResponse, ex));
                omSnapshotIntMetrics.incNumSnapshotPurgeFails();
                LOG.error("Failed to execute snapshotPurgeRequest:{{}}.", (Object)snapshotPurgeRequest, (Object)ex);
                if (!LOG.isDebugEnabled()) break block6;
                LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
                auditParams.put(AUDIT_PARAM_SNAPSHOT_DB_KEYS, snapshotDbKeys.toString());
                AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_PURGE, auditParams, ex));
            }
        }
        return omClientResponse;
    }

    private void updateSnapshotInfoAndCache(SnapshotInfo snapInfo, OmMetadataManagerImpl omMetadataManager, long trxnLogIndex) throws IOException {
        if (snapInfo != null) {
            snapInfo.setDeepClean(false);
            snapInfo.setDeepCleanedDeletedDir(false);
            omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)snapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)snapInfo));
            this.updatedSnapshotInfos.put(snapInfo.getTableKey(), snapInfo);
        }
    }

    private void updateSnapshotChainAndCache(OmMetadataManagerImpl metadataManager, SnapshotInfo snapInfo, long trxnLogIndex) throws IOException {
        SnapshotInfo nextGlobalSnapInfo;
        SnapshotInfo nextPathSnapInfo;
        boolean hasNextGlobalSnapshot;
        boolean hasNextPathSnapshot;
        if (snapInfo == null) {
            return;
        }
        SnapshotChainManager snapshotChainManager = metadataManager.getSnapshotChainManager();
        try {
            hasNextPathSnapshot = snapshotChainManager.hasNextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            hasNextGlobalSnapshot = snapshotChainManager.hasNextGlobalSnapshot(snapInfo.getSnapshotId());
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
        String nextPathSnapshotKey = null;
        if (hasNextPathSnapshot) {
            UUID nextPathSnapshotId = snapshotChainManager.nextPathSnapshot(snapInfo.getSnapshotPath(), snapInfo.getSnapshotId());
            nextPathSnapshotKey = snapshotChainManager.getTableKey(nextPathSnapshotId);
        }
        String nextGlobalSnapshotKey = null;
        if (hasNextGlobalSnapshot) {
            UUID nextGlobalSnapshotId = snapshotChainManager.nextGlobalSnapshot(snapInfo.getSnapshotId());
            nextGlobalSnapshotKey = snapshotChainManager.getTableKey(nextGlobalSnapshotId);
        }
        SnapshotInfo snapshotInfo = nextPathSnapInfo = nextPathSnapshotKey != null ? this.getUpdatedSnapshotInfo(nextPathSnapshotKey, metadataManager) : null;
        if (nextPathSnapInfo != null) {
            nextPathSnapInfo.setPathPreviousSnapshotId(snapInfo.getPathPreviousSnapshotId());
            metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextPathSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextPathSnapInfo));
        }
        SnapshotInfo snapshotInfo2 = nextGlobalSnapInfo = nextGlobalSnapshotKey != null ? this.getUpdatedSnapshotInfo(nextGlobalSnapshotKey, metadataManager) : null;
        if (nextGlobalSnapInfo != null) {
            nextGlobalSnapInfo.setGlobalPreviousSnapshotId(snapInfo.getGlobalPreviousSnapshotId());
            metadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)nextGlobalSnapInfo.getTableKey()), CacheValue.get((long)trxnLogIndex, (Object)nextGlobalSnapInfo));
        }
        snapshotChainManager.deleteSnapshot(snapInfo);
    }

    private SnapshotInfo getUpdatedSnapshotInfo(String snapshotTableKey, OMMetadataManager omMetadataManager) throws IOException {
        SnapshotInfo snapshotInfo = this.updatedSnapshotInfos.get(snapshotTableKey);
        if (snapshotInfo == null && (snapshotInfo = (SnapshotInfo)omMetadataManager.getSnapshotInfoTable().get((Object)snapshotTableKey)) != null) {
            this.updatedSnapshotInfos.put(snapshotTableKey, snapshotInfo);
        }
        return snapshotInfo;
    }
}

