/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.security;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3SecretRequestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(S3SecretRequestHelper.class);

    private S3SecretRequestHelper() {
    }

    public static UserGroupInformation getOrCreateUgi(String accessId) {
        UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
        if (ugi == null && Strings.isNotEmpty((CharSequence)accessId)) {
            return UserGroupInformation.createRemoteUser((String)accessId, (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        }
        return ugi;
    }

    public static void checkAccessIdSecretOpPermission(OzoneManager ozoneManager, UserGroupInformation ugi, String accessId) throws IOException {
        boolean isAccessIdAssignedToTenant = false;
        if (ozoneManager.isS3MultiTenancyEnabled()) {
            OMMultiTenantManager multiTenantManager = ozoneManager.getMultiTenantManager();
            Optional<String> optionalTenantId = multiTenantManager.getTenantForAccessID(accessId);
            isAccessIdAssignedToTenant = optionalTenantId.isPresent();
            if (isAccessIdAssignedToTenant) {
                String accessIdOwnerUsername = multiTenantManager.getUserNameGivenAccessId(accessId);
                String tenantId = optionalTenantId.get();
                String shortName = ugi.getShortUserName();
                if (!shortName.equals(accessIdOwnerUsername) && !multiTenantManager.isTenantAdmin(ugi, tenantId, false)) {
                    throw new OMException("Requested accessId '" + accessId + "' doesn't" + " belong to current user '" + shortName + "', nor does" + " current user have Ozone or tenant administrator privilege", OMException.ResultCodes.USER_MISMATCH);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("S3 Multi-Tenancy is enabled, but the requested accessId '{}' is not assigned to a tenant. Falling back to the old permission check", (Object)accessId);
            }
        }
        String fullPrincipal = ugi.getUserName();
        if (!(isAccessIdAssignedToTenant || fullPrincipal.equals(accessId) || ozoneManager.isS3Admin(ugi))) {
            throw new OMException("Requested accessId '" + accessId + "' doesn't match current user '" + fullPrincipal + "', nor does current user has administrator privilege.", OMException.ResultCodes.USER_MISMATCH);
        }
    }
}

