/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.OMSystemAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMDirectoriesPurgeResponseWithFSO;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.server.protocol.TermIndex;

public class OMDirectoriesPurgeRequestWithFSO
extends OMKeyRequest {
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMSYSTEMLOGGER);
    private static final String AUDIT_PARAM_DIRS_DELETED = "directoriesDeleted";
    private static final String AUDIT_PARAM_SUBDIRS_MOVED = "subdirectoriesMoved";
    private static final String AUDIT_PARAM_SUBFILES_MOVED = "subFilesMoved";
    private static final String AUDIT_PARAM_DIRS_DELETED_LIST = "directoriesDeletedList";
    private static final String AUDIT_PARAM_SUBDIRS_MOVED_LIST = "subdirectoriesMovedList";
    private static final String AUDIT_PARAM_SUBFILES_MOVED_LIST = "subFilesMovedList";
    private static final String AUDIT_PARAM_SNAPSHOT_ID = "snapshotId";

    public OMDirectoriesPurgeRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest, BucketLayout.FILE_SYSTEM_OPTIMIZED);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        purgeDirsRequest = this.getOmRequest().getPurgeDirectoriesRequest();
        fromSnapshot = purgeDirsRequest.hasSnapshotTableKey() != false ? purgeDirsRequest.getSnapshotTableKey() : null;
        purgeRequests = purgeDirsRequest.getDeletedPathList();
        volBucketInfoMap = new HashMap<Pair<String, String>, OmBucketInfo>();
        omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        openKeyInfoMap = new HashMap<String, OmKeyInfo>();
        omMetrics = ozoneManager.getMetrics();
        deletingServiceMetrics = ozoneManager.getDeletionMetrics();
        omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        subDirNames = new HashSet<String>();
        subFileNames = new HashSet<String>();
        deletedDirNames = new HashSet<String>();
        try {
            v0 = fromSnapshotInfo = fromSnapshot != null ? SnapshotUtils.getSnapshotInfo(ozoneManager, fromSnapshot) : null;
            if (purgeDirsRequest.hasExpectedPreviousSnapshotID()) {
                expectedPreviousSnapshotId = purgeDirsRequest.getExpectedPreviousSnapshotID().hasUuid() != false ? HddsUtils.fromProtobuf((HddsProtos.UUID)purgeDirsRequest.getExpectedPreviousSnapshotID().getUuid()) : null;
                SnapshotUtils.validatePreviousSnapshotId(fromSnapshotInfo, omMetadataManager.getSnapshotChainManager(), expectedPreviousSnapshotId);
            }
        }
        catch (IOException e) {
            OMKeyRequest.LOG.error("Error occurred while performing OMDirectoriesPurge. ", (Throwable)e);
            if (OMKeyRequest.LOG.isDebugEnabled()) {
                OMDirectoriesPurgeRequestWithFSO.AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.DIRECTORY_DELETION, null, e));
            }
            return new OMDirectoriesPurgeResponseWithFSO(this.createErrorOMResponse(omResponse, e));
        }
        bucketLockKeys = this.getBucketLockKeySet(purgeDirsRequest);
        lockAcquired = omMetadataManager.getLock().acquireWriteLocks((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, bucketLockKeys).isLockAcquired();
        if (!lockAcquired && !purgeDirsRequest.getBucketNameInfosList().isEmpty()) {
            oe = new OMException("Unable to acquire write locks on buckets while performing DirectoryPurge", OMException.ResultCodes.KEY_DELETION_ERROR);
            OMKeyRequest.LOG.error("Error occurred while performing OMDirectoriesPurge. ", (Throwable)oe);
            OMDirectoriesPurgeRequestWithFSO.AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.DIRECTORY_DELETION, null, oe));
            return new OMDirectoriesPurgeResponseWithFSO(this.createErrorOMResponse(omResponse, (Exception)oe));
        }
        try {
            numSubDirMoved = 0;
            numSubFilesMoved = 0;
            numDirsDeleted = 0;
            volumeBucketIdMap = purgeDirsRequest.getBucketNameInfosList().stream().collect(Collectors.toMap((Function<OzoneManagerProtocolProtos.BucketNameInfo, OMMetadataManager.VolumeBucketId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$BucketNameInfo ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$BucketNameInfo;)Lorg/apache/hadoop/ozone/om/OMMetadataManager$VolumeBucketId;)(), Function.identity()));
            var23_25 = purgeRequests.iterator();
lbl38:
            // 3 sources

            while (true) {
                block22: {
                    block21: {
                        block20: {
                            if (var23_25.hasNext()) break block20;
                            subDirNames.removeAll(deletedDirNames);
                            numSubDirMoved = subDirNames.size();
                            deletingServiceMetrics.incrNumSubDirectoriesMoved(numSubDirMoved);
                            deletingServiceMetrics.incrNumSubFilesMoved(numSubFilesMoved);
                            deletingServiceMetrics.incrNumDirPurged(numDirsDeleted);
                            transactionInfo = TransactionInfo.valueOf((TermIndex)context.getTermIndex());
                            if (fromSnapshotInfo == null) break block21;
                            fromSnapshotInfo.setLastTransactionInfo(transactionInfo.toByteString());
                            omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshotInfo.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)fromSnapshotInfo));
                            break block22;
                        }
                        path = (OzoneManagerProtocolProtos.PurgePathRequest)var23_25.next();
                        var25_28 = path.getMarkDeletedSubDirsList().iterator();
                        if (true) ** GOTO lbl99
                    }
                    deletingServiceMetrics.setLastAOSTransactionInfo(transactionInfo);
                }
                if (OMKeyRequest.LOG.isDebugEnabled()) {
                    auditParams = new LinkedHashMap<String, String>();
                    if (fromSnapshotInfo != null) {
                        auditParams.put("snapshotId", fromSnapshotInfo.getSnapshotId().toString());
                    }
                    auditParams.put("directoriesDeleted", String.valueOf(numDirsDeleted));
                    auditParams.put("subdirectoriesMoved", String.valueOf(numSubDirMoved));
                    auditParams.put("subFilesMoved", String.valueOf(numSubFilesMoved));
                    auditParams.put("directoriesDeletedList", String.join((CharSequence)",", deletedDirNames));
                    auditParams.put("subdirectoriesMovedList", String.join((CharSequence)",", subDirNames));
                    auditParams.put("subFilesMovedList", String.join((CharSequence)",", subFileNames));
                    OMDirectoriesPurgeRequestWithFSO.AUDIT.logWriteSuccess(ozoneManager.buildAuditMessageForSuccess(OMSystemAction.DIRECTORY_DELETION, auditParams));
                }
                break;
            }
        }
        catch (IOException ex) {
            if (OMKeyRequest.LOG.isDebugEnabled()) {
                OMDirectoriesPurgeRequestWithFSO.AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.DIRECTORY_DELETION, null, ex));
            }
            throw new IllegalStateException(ex);
        }
        finally {
            var35_39 = volBucketInfoMap.entrySet().iterator();
            if (true) ** GOTO lbl141
        }
        do {
            key = (OzoneManagerProtocolProtos.KeyInfo)var25_28.next();
            processed = this.processDeleteKey(key, path, omMetadataManager);
            subDirNames.add(ProcessedKeyInfo.access$0(processed));
            omMetrics.decNumKeys();
            omBucketInfo = OMDirectoriesPurgeRequestWithFSO.getBucketInfo(omMetadataManager, ProcessedKeyInfo.access$1(processed), ProcessedKeyInfo.access$2(processed));
            if (omBucketInfo == null || omBucketInfo.getObjectID() != path.getBucketId()) continue;
            omBucketInfo.decrUsedNamespace(1L, true);
            ozoneDbKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), ProcessedKeyInfo.access$3(processed).getParentObjectID(), ProcessedKeyInfo.access$3(processed).getFileName());
            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)ozoneDbKey), CacheValue.get((long)context.getIndex()));
            volBucketInfoMap.putIfAbsent((Pair<String, String>)ProcessedKeyInfo.access$4(processed), omBucketInfo);
lbl99:
            // 3 sources

        } while (var25_28.hasNext());
        for (OzoneManagerProtocolProtos.KeyInfo key : path.getDeletedSubFilesList()) {
            processed = this.processDeleteKey(key, path, omMetadataManager);
            subFileNames.add(ProcessedKeyInfo.access$0(processed));
            hsyncClientId = (String)ProcessedKeyInfo.access$3(processed).getMetadata().get("hsyncClientId");
            if (hsyncClientId != null) {
                parentId = ProcessedKeyInfo.access$3(processed).getParentObjectID();
                dbOpenKey = omMetadataManager.getOpenFileName(path.getVolumeId(), path.getBucketId(), parentId, ProcessedKeyInfo.access$3(processed).getFileName(), hsyncClientId);
                openKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbOpenKey);
                if (openKeyInfo != null) {
                    openKeyInfo.getMetadata().put("deletedHsyncKey", "true");
                    openKeyInfoMap.put(dbOpenKey, openKeyInfo);
                }
            }
            omMetrics.decNumKeys();
            ++numSubFilesMoved;
            omBucketInfo = OMDirectoriesPurgeRequestWithFSO.getBucketInfo(omMetadataManager, ProcessedKeyInfo.access$1(processed), ProcessedKeyInfo.access$2(processed));
            if (omBucketInfo == null || omBucketInfo.getObjectID() != path.getBucketId()) continue;
            totalSize = OMDirectoriesPurgeRequestWithFSO.sumBlockLengths(ProcessedKeyInfo.access$3(processed));
            omBucketInfo.decrUsedBytes(totalSize, true);
            omBucketInfo.decrUsedNamespace(1L, true);
            ozoneDbKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), ProcessedKeyInfo.access$3(processed).getParentObjectID(), ProcessedKeyInfo.access$3(processed).getFileName());
            omMetadataManager.getFileTable().addCacheEntry(new CacheKey((Object)ozoneDbKey), CacheValue.get((long)context.getIndex()));
            volBucketInfoMap.putIfAbsent((Pair<String, String>)ProcessedKeyInfo.access$4(processed), omBucketInfo);
        }
        if (!path.hasDeletedDir()) ** GOTO lbl38
        deletedDirNames.add(path.getDeletedDir());
        bucketNameInfo = (OzoneManagerProtocolProtos.BucketNameInfo)volumeBucketIdMap.get(new OMMetadataManager.VolumeBucketId(path.getVolumeId(), path.getBucketId()));
        omBucketInfo = OMDirectoriesPurgeRequestWithFSO.getBucketInfo(omMetadataManager, bucketNameInfo.getVolumeName(), bucketNameInfo.getBucketName());
        if (omBucketInfo != null && omBucketInfo.getObjectID() == path.getBucketId()) {
            omBucketInfo.purgeSnapshotUsedNamespace(1L);
            volBucketInfoMap.put((Pair<String, String>)Pair.of((Object)omBucketInfo.getVolumeName(), (Object)omBucketInfo.getBucketName()), omBucketInfo);
        }
        ++numDirsDeleted;
        ** continue;
        do {
            entry = var35_39.next();
            entry.setValue(((OmBucketInfo)entry.getValue()).copyObject());
lbl141:
            // 2 sources

        } while (var35_39.hasNext());
        omMetadataManager.getLock().releaseWriteLocks((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, bucketLockKeys);
        return new OMDirectoriesPurgeResponseWithFSO(omResponse.build(), purgeRequests, this.getBucketLayout(), volBucketInfoMap, fromSnapshotInfo, openKeyInfoMap);
    }

    private ProcessedKeyInfo processDeleteKey(OzoneManagerProtocolProtos.KeyInfo key, OzoneManagerProtocolProtos.PurgePathRequest path, OmMetadataManagerImpl omMetadataManager) {
        OmKeyInfo keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)key);
        String pathKey = omMetadataManager.getOzonePathKey(path.getVolumeId(), path.getBucketId(), keyInfo.getParentObjectID(), keyInfo.getFileName());
        String deleteKey = omMetadataManager.getOzoneDeletePathKey(keyInfo.getObjectID(), pathKey);
        String volumeName = keyInfo.getVolumeName();
        String bucketName = keyInfo.getBucketName();
        return new ProcessedKeyInfo(keyInfo, deleteKey, volumeName, bucketName);
    }

    /*
     * Exception decompiling
     */
    private List<String[]> getBucketLockKeySet(OzoneManagerProtocolProtos.PurgeDirectoriesRequest purgeDirsRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ OMMetadataManager.VolumeBucketId lambda$0(OzoneManagerProtocolProtos.BucketNameInfo bucketNameInfo) {
        return new OMMetadataManager.VolumeBucketId(bucketNameInfo.getVolumeId(), bucketNameInfo.getBucketId());
    }

    private static class ProcessedKeyInfo {
        private final OmKeyInfo keyInfo;
        private final String deleteKey;
        private final String volumeName;
        private final String bucketName;
        private final Pair<String, String> volBucketPair;

        ProcessedKeyInfo(OmKeyInfo keyInfo, String deleteKey, String volumeName, String bucketName) {
            this.keyInfo = keyInfo;
            this.deleteKey = deleteKey;
            this.volumeName = volumeName;
            this.bucketName = bucketName;
            this.volBucketPair = Pair.of((Object)volumeName, (Object)bucketName);
        }

        static /* synthetic */ String access$0(ProcessedKeyInfo processedKeyInfo) {
            return processedKeyInfo.deleteKey;
        }

        static /* synthetic */ String access$1(ProcessedKeyInfo processedKeyInfo) {
            return processedKeyInfo.volumeName;
        }

        static /* synthetic */ String access$2(ProcessedKeyInfo processedKeyInfo) {
            return processedKeyInfo.bucketName;
        }

        static /* synthetic */ OmKeyInfo access$3(ProcessedKeyInfo processedKeyInfo) {
            return processedKeyInfo.keyInfo;
        }

        static /* synthetic */ Pair access$4(ProcessedKeyInfo processedKeyInfo) {
            return processedKeyInfo.volBucketPair;
        }
    }
}

