/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRawSSTFileReader;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotLocalData;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.FlatResource;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.snapshot.MultiSnapshotLocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDefragService
extends BackgroundService
implements BootstrapStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDefragService.class);
    private static final int DEFRAG_CORE_POOL_SIZE = 1;
    private final OzoneManager ozoneManager;
    private final AtomicLong runCount = new AtomicLong(0L);
    private final long snapshotLimitPerTask;
    private final AtomicLong snapshotsDefraggedCount;
    private final AtomicBoolean running;
    private final MultiSnapshotLocks snapshotIdLocks;
    private final BootstrapStateHandler.Lock lock = new BootstrapStateHandler.Lock();

    public SnapshotDefragService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration) {
        super("SnapshotDefragService", interval, unit, 1, serviceTimeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.snapshotLimitPerTask = configuration.getLong("ozone.snapshot.defrag.limit.per.task", 1L);
        this.snapshotsDefraggedCount = new AtomicLong(0L);
        this.running = new AtomicBoolean(false);
        IOzoneManagerLock omLock = ozoneManager.getMetadataManager().getLock();
        this.snapshotIdLocks = new MultiSnapshotLocks(omLock, (IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_GC_LOCK, true);
    }

    public void start() {
        this.running.set(true);
        super.start();
    }

    @VisibleForTesting
    public void pause() {
        this.running.set(false);
    }

    @VisibleForTesting
    public void resume() {
        this.running.set(true);
    }

    private boolean isRocksToolsNativeLibAvailable() {
        try {
            return ManagedRawSSTFileReader.tryLoadLibrary();
        }
        catch (Exception e) {
            LOG.warn("Failed to check native code availability", (Throwable)e);
            return false;
        }
    }

    private boolean needsDefragmentation(SnapshotInfo snapshotInfo) {
        OmSnapshotManager.getSnapshotPath(this.ozoneManager.getConfiguration(), snapshotInfo);
        try {
            OmSnapshotLocalData snapshotLocalData = this.ozoneManager.getOmSnapshotManager().getSnapshotLocalDataManager().getOmSnapshotLocalData(snapshotInfo);
            boolean needsDefrag = snapshotLocalData.getNeedsDefrag();
            LOG.debug("Snapshot {} needsDefragmentation field value: {}", (Object)snapshotInfo.getName(), (Object)needsDefrag);
            return needsDefrag;
        }
        catch (IOException e) {
            LOG.warn("Failed to read YAML metadata for snapshot {}, assuming defrag needed", (Object)snapshotInfo.getName(), (Object)e);
            return true;
        }
    }

    private void performFullDefragmentation(SnapshotInfo snapshotInfo, OmSnapshot omSnapshot) throws IOException {
    }

    private void performIncrementalDefragmentation(SnapshotInfo currentSnapshot, SnapshotInfo previousDefraggedSnapshot, OmSnapshot currentOmSnapshot) throws IOException {
    }

    /*
     * Exception decompiling
     */
    public synchronized boolean triggerSnapshotDefragOnce() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SnapshotDefragTask());
        return queue;
    }

    private boolean shouldRun() {
        if (this.ozoneManager == null) {
            return true;
        }
        if (this.ozoneManager.getOmRatisServer() == null) {
            LOG.warn("OzoneManagerRatisServer is not initialized yet");
            return false;
        }
        return this.running.get() && this.ozoneManager.isRunning();
    }

    public AtomicLong getSnapshotsDefraggedCount() {
        return this.snapshotsDefraggedCount;
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    public void shutdown() {
        this.running.set(false);
        super.shutdown();
    }

    private final class SnapshotDefragTask
    implements BackgroundTask {
        private SnapshotDefragTask() {
        }

        public BackgroundTaskResult call() throws Exception {
            if (SnapshotDefragService.this.shouldRun()) {
                long count = SnapshotDefragService.this.runCount.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Initiating Snapshot Defragmentation Task: run # {}", (Object)count);
                }
                SnapshotDefragService.this.triggerSnapshotDefragOnce();
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

