/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.TableCacheMetrics;
import org.apache.hadoop.hdds.utils.db.AutoCloseSupplier;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.FullTableCache;
import org.apache.hadoop.hdds.utils.db.cache.PartialTableCache;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.hdds.utils.db.cache.TableNoCache;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.function.CheckedBiFunction;

public class TypedTable<KEY, VALUE>
implements Table<KEY, VALUE> {
    private static final long EPOCH_DEFAULT = -1L;
    static final int BUFFER_SIZE_DEFAULT = 4096;
    private final RDBTable rawTable;
    private final String info;
    private final Codec<KEY> keyCodec;
    private final Codec<VALUE> valueCodec;
    private final boolean supportCodecBuffer;
    private final CodecBuffer.Capacity bufferCapacity = new CodecBuffer.Capacity((Object)this, 4096);
    private final TableCache<KEY, VALUE> cache;

    TypedTable(RDBTable rawTable, Codec<KEY> keyCodec, Codec<VALUE> valueCodec, TableCache.CacheType cacheType) throws RocksDatabaseException, CodecException {
        this.rawTable = Objects.requireNonNull(rawTable, "rawTable==null");
        this.keyCodec = Objects.requireNonNull(keyCodec, "keyCodec == null");
        this.valueCodec = Objects.requireNonNull(valueCodec, "valueCodec == null");
        this.info = JavaUtils.getClassSimpleName(this.getClass()) + "-" + this.getName() + "(" + JavaUtils.getClassSimpleName((Class)keyCodec.getTypeClass()) + "->" + JavaUtils.getClassSimpleName((Class)valueCodec.getTypeClass()) + ")";
        this.supportCodecBuffer = keyCodec.supportCodecBuffer() && valueCodec.supportCodecBuffer();
        String threadNamePrefix = rawTable.getName() + "_";
        if (cacheType == TableCache.CacheType.FULL_CACHE) {
            this.cache = new FullTableCache(threadNamePrefix);
            try (Table.KeyValueIterator tableIterator = this.iterator();){
                while (tableIterator.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)tableIterator.next();
                    this.cache.loadInitial(new CacheKey(kv.getKey()), CacheValue.get(-1L, kv.getValue()));
                }
            }
        } else {
            this.cache = cacheType == TableCache.CacheType.PARTIAL_CACHE ? new PartialTableCache(threadNamePrefix) : TableNoCache.instance();
        }
    }

    private CodecBuffer encodeKeyCodecBuffer(KEY key) throws CodecException {
        return key == null ? null : this.keyCodec.toDirectCodecBuffer(key);
    }

    private byte[] encodeKey(KEY key) throws CodecException {
        return key == null ? null : this.keyCodec.toPersistedFormat(key);
    }

    private byte[] encodeValue(VALUE value) throws CodecException {
        return value == null ? null : this.valueCodec.toPersistedFormat(value);
    }

    private KEY decodeKey(byte[] key) throws CodecException {
        return (KEY)(key != null ? this.keyCodec.fromPersistedFormat(key) : null);
    }

    private VALUE decodeValue(byte[] value) throws CodecException {
        return (VALUE)(value != null ? this.valueCodec.fromPersistedFormat(value) : null);
    }

    @Override
    public void put(KEY key, VALUE value) throws RocksDatabaseException, CodecException {
        block13: {
            if (this.supportCodecBuffer) {
                try (CodecBuffer k = this.keyCodec.toDirectCodecBuffer(key);
                     CodecBuffer v = this.valueCodec.toDirectCodecBuffer(value);){
                    this.rawTable.put(k.asReadOnlyByteBuffer(), v.asReadOnlyByteBuffer());
                    break block13;
                }
            }
            this.rawTable.put(this.encodeKey(key), this.encodeValue(value));
        }
    }

    @Override
    public void putWithBatch(BatchOperation batch, KEY key, VALUE value) throws RocksDatabaseException, CodecException {
        if (this.supportCodecBuffer) {
            CodecBuffer keyBuffer = null;
            CodecBuffer valueBuffer = null;
            try {
                keyBuffer = this.keyCodec.toDirectCodecBuffer(key);
                valueBuffer = this.valueCodec.toDirectCodecBuffer(value);
                this.rawTable.putWithBatch(batch, keyBuffer, valueBuffer);
            }
            catch (Exception e) {
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{valueBuffer, keyBuffer});
                throw e;
            }
        } else {
            this.rawTable.putWithBatch(batch, this.encodeKey(key), this.encodeValue(value));
        }
    }

    @Override
    public boolean isEmpty() throws RocksDatabaseException {
        return this.rawTable.isEmpty();
    }

    @Override
    public boolean isExist(KEY key) throws RocksDatabaseException, CodecException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return true;
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return false;
        }
        if (this.keyCodec.supportCodecBuffer()) {
            try (CodecBuffer inKey = this.keyCodec.toDirectCodecBuffer(key);){
                boolean bl;
                block15: {
                    CodecBuffer outValue = CodecBuffer.getEmptyBuffer();
                    try {
                        boolean bl2 = bl = this.getFromTableIfExist(inKey, outValue) != null;
                        if (outValue == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (outValue != null) {
                            try {
                                outValue.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    outValue.close();
                }
                return bl;
            }
        }
        return this.rawTable.isExist(this.encodeKey(key));
    }

    @Override
    public VALUE get(KEY key) throws RocksDatabaseException, CodecException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return (VALUE)this.valueCodec.copyObject(cacheResult.getValue().getCacheValue());
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTable(key);
    }

    @Override
    public VALUE getSkipCache(KEY key) throws RocksDatabaseException, CodecException {
        return this.getFromTable(key);
    }

    @Override
    public VALUE getReadCopy(KEY key) throws RocksDatabaseException, CodecException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return cacheResult.getValue().getCacheValue();
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTable(key);
    }

    @Override
    public VALUE getIfExist(KEY key) throws RocksDatabaseException, CodecException {
        CacheResult<VALUE> cacheResult = this.cache.lookup(new CacheKey<KEY>(key));
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.EXISTS) {
            return (VALUE)this.valueCodec.copyObject(cacheResult.getValue().getCacheValue());
        }
        if (cacheResult.getCacheStatus() == CacheResult.CacheStatus.NOT_EXIST) {
            return null;
        }
        return this.getFromTableIfExist(key);
    }

    private Integer getFromTable(CodecBuffer key, CodecBuffer outValue) throws RocksDatabaseException {
        return outValue.putFromSource(buffer -> this.rawTable.get(key.asReadOnlyByteBuffer(), (ByteBuffer)buffer));
    }

    private VALUE getFromTable(KEY key) throws RocksDatabaseException, CodecException {
        if (this.supportCodecBuffer) {
            return this.getFromTable(key, (CheckedBiFunction<CodecBuffer, CodecBuffer, Integer, RocksDatabaseException>)((CheckedBiFunction)this::getFromTable));
        }
        byte[] keyBytes = this.encodeKey(key);
        byte[] valueBytes = this.rawTable.get(keyBytes);
        return this.decodeValue(valueBytes);
    }

    private Integer getFromTableIfExist(CodecBuffer key, CodecBuffer outValue) throws RocksDatabaseException {
        return outValue.putFromSource(buffer -> this.rawTable.getIfExist(key.asReadOnlyByteBuffer(), (ByteBuffer)buffer));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VALUE getFromTable(KEY key, CheckedBiFunction<CodecBuffer, CodecBuffer, Integer, RocksDatabaseException> get) throws RocksDatabaseException, CodecException {
        try (CodecBuffer inKey = this.keyCodec.toDirectCodecBuffer(key);){
            while (true) {
                Integer required;
                int initial = -this.bufferCapacity.get();
                try (CodecBuffer outValue = CodecBuffer.allocateDirect((int)initial);){
                    required = (Integer)get.apply((Object)inKey, (Object)outValue);
                    if (required == null) {
                        VALUE VALUE = null;
                        return VALUE;
                    }
                    if (required < 0) {
                        throw new IllegalStateException("required = " + required + " < 0");
                    }
                    while (true) {
                        if (required.intValue() == outValue.readableBytes()) {
                            Object object = this.valueCodec.fromCodecBuffer(outValue);
                            return (VALUE)object;
                        }
                        if (outValue.setCapacity(required.intValue())) {
                            outValue.clear();
                            int retried = (Integer)get.apply((Object)inKey, (Object)outValue);
                            Preconditions.assertSame((int)required, (int)retried, (String)"required");
                            continue;
                        }
                        break;
                    }
                }
                this.bufferCapacity.increase(required.intValue());
            }
        }
    }

    private VALUE getFromTableIfExist(KEY key) throws RocksDatabaseException, CodecException {
        if (this.supportCodecBuffer) {
            return this.getFromTable(key, (CheckedBiFunction<CodecBuffer, CodecBuffer, Integer, RocksDatabaseException>)((CheckedBiFunction)this::getFromTableIfExist));
        }
        byte[] keyBytes = this.encodeKey(key);
        byte[] valueBytes = this.rawTable.getIfExist(keyBytes);
        return this.decodeValue(valueBytes);
    }

    @Override
    public void delete(KEY key) throws RocksDatabaseException, CodecException {
        if (this.keyCodec.supportCodecBuffer()) {
            try (CodecBuffer buffer = this.keyCodec.toDirectCodecBuffer(key);){
                this.rawTable.delete(buffer.asReadOnlyByteBuffer());
            }
        } else {
            this.rawTable.delete(this.encodeKey(key));
        }
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, KEY key) throws CodecException {
        this.rawTable.deleteWithBatch(batch, this.encodeKey(key));
    }

    @Override
    public void deleteRangeWithBatch(BatchOperation batch, KEY beginKey, KEY endKey) throws CodecException {
        this.rawTable.deleteRangeWithBatch(batch, this.encodeKey(beginKey), this.encodeKey(endKey));
    }

    @Override
    public void deleteRange(KEY beginKey, KEY endKey) throws RocksDatabaseException, CodecException {
        this.rawTable.deleteRange(this.encodeKey(beginKey), this.encodeKey(endKey));
    }

    @Override
    public Table.KeyValueIterator<KEY, VALUE> iterator(KEY prefix, Table.KeyValueIterator.Type type) throws RocksDatabaseException, CodecException {
        if (this.supportCodecBuffer) {
            return this.newCodecBufferTableIterator(prefix, type);
        }
        byte[] prefixBytes = this.encodeKey(prefix);
        return new TypedTableIterator(this.rawTable.iterator(prefixBytes, type));
    }

    @Override
    public String getName() {
        return this.rawTable.getName();
    }

    public String toString() {
        return this.info;
    }

    @Override
    public long getEstimatedKeyCount() throws RocksDatabaseException {
        if (this.cache.getCacheType() == TableCache.CacheType.FULL_CACHE) {
            return this.cache.size();
        }
        return this.rawTable.getEstimatedKeyCount();
    }

    @Override
    public void addCacheEntry(CacheKey<KEY> cacheKey, CacheValue<VALUE> cacheValue) {
        this.cache.put(cacheKey, cacheValue);
    }

    @Override
    public CacheValue<VALUE> getCacheValue(CacheKey<KEY> cacheKey) {
        return this.cache.get(cacheKey);
    }

    @Override
    public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> cacheIterator() {
        return this.cache.iterator();
    }

    @Override
    public TableCacheMetrics createCacheMetrics() {
        return TableCacheMetrics.create(this.cache, this.getName());
    }

    @Override
    public List<Table.KeyValue<KEY, VALUE>> getRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.KeyPrefixFilter filter, boolean isSequential) throws RocksDatabaseException, CodecException {
        byte[] startKeyBytes = this.encodeKey(startKey);
        byte[] prefixBytes = this.encodeKey(prefix);
        List<Table.KeyValue<byte[], byte[]>> rangeKVBytes = this.rawTable.getRangeKVs(startKeyBytes, count, prefixBytes, filter, isSequential);
        ArrayList<Table.KeyValue<KEY, VALUE>> rangeKVs = new ArrayList<Table.KeyValue<KEY, VALUE>>();
        for (Table.KeyValue<byte[], byte[]> kv : rangeKVBytes) {
            rangeKVs.add(Table.newKeyValue(this.decodeKey(kv.getKey()), this.decodeValue(kv.getValue())));
        }
        return rangeKVs;
    }

    @Override
    public void deleteBatchWithPrefix(BatchOperation batch, KEY prefix) throws RocksDatabaseException, CodecException {
        this.rawTable.deleteBatchWithPrefix(batch, this.encodeKey(prefix));
    }

    @Override
    public void dumpToFileWithPrefix(File externalFile, KEY prefix) throws RocksDatabaseException, CodecException {
        this.rawTable.dumpToFileWithPrefix(externalFile, this.encodeKey(prefix));
    }

    @Override
    public void loadFromFile(File externalFile) throws RocksDatabaseException {
        this.rawTable.loadFromFile(externalFile);
    }

    @Override
    public void cleanupCache(List<Long> epochs) {
        this.cache.cleanup(epochs);
    }

    @VisibleForTesting
    TableCache<KEY, VALUE> getCache() {
        return this.cache;
    }

    private RawIterator<CodecBuffer> newCodecBufferTableIterator(KEY prefix, Table.KeyValueIterator.Type type) throws RocksDatabaseException, CodecException {
        CodecBuffer prefixBuffer;
        CodecBuffer encoded = this.encodeKeyCodecBuffer(prefix);
        if (encoded != null && encoded.readableBytes() == 0) {
            encoded.release();
            prefixBuffer = null;
        } else {
            prefixBuffer = encoded;
        }
        try {
            return this.newCodecBufferTableIterator(this.rawTable.iterator(prefixBuffer, type));
        }
        catch (Throwable t) {
            if (prefixBuffer != null) {
                prefixBuffer.release();
            }
            throw t;
        }
    }

    private RawIterator<CodecBuffer> newCodecBufferTableIterator(Table.KeyValueIterator<CodecBuffer, CodecBuffer> i) {
        return new RawIterator<CodecBuffer>(i){

            @Override
            AutoCloseSupplier<CodecBuffer> convert(KEY key) throws CodecException {
                final CodecBuffer buffer = TypedTable.this.encodeKeyCodecBuffer(key);
                return new AutoCloseSupplier<CodecBuffer>(){

                    @Override
                    public void close() {
                        buffer.release();
                    }

                    @Override
                    public CodecBuffer get() {
                        return buffer;
                    }
                };
            }

            @Override
            Table.KeyValue<KEY, VALUE> convert(Table.KeyValue<CodecBuffer, CodecBuffer> raw) throws CodecException {
                CodecBuffer keyBuffer = raw.getKey();
                Object key = keyBuffer != null ? TypedTable.this.keyCodec.fromCodecBuffer(keyBuffer) : null;
                CodecBuffer valueBuffer = raw.getValue();
                return valueBuffer == null ? Table.newKeyValue(key, null) : Table.newKeyValue(key, TypedTable.this.valueCodec.fromCodecBuffer(valueBuffer), valueBuffer.readableBytes());
            }
        };
    }

    abstract class RawIterator<RAW>
    implements Table.KeyValueIterator<KEY, VALUE> {
        private final Table.KeyValueIterator<RAW, RAW> rawIterator;

        RawIterator(Table.KeyValueIterator<RAW, RAW> rawIterator) {
            this.rawIterator = rawIterator;
        }

        abstract AutoCloseSupplier<RAW> convert(KEY var1) throws CodecException;

        abstract Table.KeyValue<KEY, VALUE> convert(Table.KeyValue<RAW, RAW> var1) throws CodecException;

        @Override
        public void seekToFirst() {
            this.rawIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.rawIterator.seekToLast();
        }

        @Override
        public Table.KeyValue<KEY, VALUE> seek(KEY key) throws RocksDatabaseException, CodecException {
            try (AutoCloseSupplier<RAW> rawKey = this.convert(key);){
                Table.KeyValue result = (Table.KeyValue)this.rawIterator.seek(rawKey.get());
                Table.KeyValue keyValue = result == null ? null : this.convert(result);
                return keyValue;
            }
        }

        @Override
        public void close() throws RocksDatabaseException {
            this.rawIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public Table.KeyValue<KEY, VALUE> next() {
            try {
                return this.convert((Table.KeyValue)this.rawIterator.next());
            }
            catch (CodecException e) {
                throw new IllegalStateException("Failed next() in " + TypedTable.this, e);
            }
        }

        @Override
        public void removeFromDB() throws RocksDatabaseException, CodecException {
            this.rawIterator.removeFromDB();
        }
    }

    public class TypedTableIterator
    extends RawIterator<byte[]> {
        TypedTableIterator(Table.KeyValueIterator<byte[], byte[]> rawIterator) {
            super(rawIterator);
        }

        @Override
        AutoCloseSupplier<byte[]> convert(KEY key) throws CodecException {
            byte[] keyArray = TypedTable.this.encodeKey(key);
            return () -> keyArray;
        }

        @Override
        Table.KeyValue<KEY, VALUE> convert(Table.KeyValue<byte[], byte[]> raw) throws CodecException {
            Object key = TypedTable.this.decodeKey(raw.getKey());
            byte[] valueBytes = raw.getValue();
            return valueBytes == null ? Table.newKeyValue(key, null) : Table.newKeyValue(key, TypedTable.this.decodeValue(valueBytes), valueBytes.length);
        }
    }
}

