/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBCheckpoint
implements DBCheckpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBCheckpoint.class);
    private Path checkpointLocation;
    private long checkpointTimestamp = System.currentTimeMillis();
    private long latestSequenceNumber = -1L;
    private long checkpointCreationTimeTaken = 0L;

    public RocksDBCheckpoint(Path checkpointLocation) {
        this.checkpointLocation = checkpointLocation;
    }

    public RocksDBCheckpoint(Path checkpointLocation, long snapshotTimestamp, long latestSequenceNumber, long checkpointCreationTimeTaken) {
        this.checkpointLocation = checkpointLocation;
        this.checkpointTimestamp = snapshotTimestamp;
        this.latestSequenceNumber = latestSequenceNumber;
        this.checkpointCreationTimeTaken = checkpointCreationTimeTaken;
    }

    @Override
    public Path getCheckpointLocation() {
        return this.checkpointLocation;
    }

    @Override
    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    @Override
    public long getLatestSequenceNumber() {
        return this.latestSequenceNumber;
    }

    @Override
    public long checkpointCreationTimeTaken() {
        return this.checkpointCreationTimeTaken;
    }

    @Override
    public void cleanupCheckpoint() throws IOException {
        LOG.info("Cleaning up RocksDB checkpoint at {}", (Object)this.checkpointLocation.toString());
        FileUtils.deleteDirectory((File)this.checkpointLocation.toFile());
    }
}

