/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedConfigOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ConfigOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.OptionsUtil;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBConfigFromFile {
    private static final Logger LOG = LoggerFactory.getLogger(DBConfigFromFile.class);
    public static final String CONFIG_DIR = "OZONE_CONF_DIR";

    private DBConfigFromFile() {
    }

    public static File getConfigLocation() {
        String path = System.getenv(CONFIG_DIR);
        if (StringUtils.isBlank((CharSequence)path)) {
            path = System.getProperty(CONFIG_DIR);
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            LOG.debug("Unable to find the configuration directory. Please make sure that OZONE_CONF_DIR is setup correctly.");
            return null;
        }
        return new File(path);
    }

    public static String getOptionsFileNameFromDB(String dbFileName) {
        Preconditions.checkNotNull((Object)dbFileName);
        return dbFileName.isEmpty() ? "" : dbFileName + ".ini";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedDBOptions readDBOptionsFromFile(Path dbPath) throws RocksDBException {
        Path generatedDBPath = DBConfigFromFile.generateDBPath(dbPath);
        if (generatedDBPath.toString().isEmpty()) {
            return null;
        }
        if (!generatedDBPath.toFile().exists()) {
            LOG.warn("Error trying to read generated rocksDB file: {}, file does not exists.", (Object)generatedDBPath);
            return null;
        }
        ArrayList<ColumnFamilyDescriptor> descriptors = new ArrayList<ColumnFamilyDescriptor>();
        try {
            ManagedDBOptions options = new ManagedDBOptions();
            try (ManagedConfigOptions configOptions = new ManagedConfigOptions();){
                OptionsUtil.loadOptionsFromFile((ConfigOptions)configOptions, (String)generatedDBPath.toString(), (DBOptions)options, descriptors);
            }
            catch (RocksDBException rdEx) {
                options.close();
                throw new RocksDBException("There was an error opening rocksDB Options file: " + rdEx.getMessage());
            }
            ManagedDBOptions managedDBOptions = options;
            return managedDBOptions;
        }
        finally {
            DBConfigFromFile.closeDescriptors(descriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedColumnFamilyOptions readCFOptionsFromFile(Path optionsPath, String cfName) throws RocksDBException {
        Path generatedDBPath = DBConfigFromFile.generateDBPath(optionsPath);
        if (generatedDBPath.toString().isEmpty()) {
            return null;
        }
        if (!generatedDBPath.toFile().exists()) {
            LOG.warn("Error trying to read column family options from file: {}, file does not exists.", (Object)generatedDBPath);
            return null;
        }
        ArrayList<ColumnFamilyDescriptor> descriptors = new ArrayList<ColumnFamilyDescriptor>();
        String defaultColumnFamilyString = StringUtils.toEncodedString((byte[])RocksDB.DEFAULT_COLUMN_FAMILY, (Charset)StandardCharsets.UTF_8);
        String validatedCfName = StringUtils.isEmpty((CharSequence)cfName) ? defaultColumnFamilyString : cfName;
        ManagedColumnFamilyOptions resultCfOptions = null;
        try (ManagedConfigOptions ignored = new ManagedConfigOptions();
             ManagedDBOptions options = new ManagedDBOptions();){
            OptionsUtil.loadOptionsFromFile((ConfigOptions)ignored, (String)generatedDBPath.toString(), (DBOptions)options, descriptors);
            ColumnFamilyDescriptor descriptor = descriptors.stream().filter(desc -> StringUtils.toEncodedString((byte[])desc.getName(), (Charset)StandardCharsets.UTF_8).equals(validatedCfName)).findAny().orElse(null);
            if (descriptor != null) {
                resultCfOptions = new ManagedColumnFamilyOptions(descriptor.getOptions());
            }
        }
        finally {
            DBConfigFromFile.closeDescriptors(descriptors);
        }
        return resultCfOptions;
    }

    private static void closeDescriptors(List<ColumnFamilyDescriptor> descriptors) {
        descriptors.forEach(descriptor -> descriptor.getOptions().close());
    }

    private static Path generateDBPath(Path path) {
        String dbPath;
        String string = dbPath = path == null ? "" : path.toString();
        if (dbPath.isEmpty()) {
            return Paths.get("", new String[0]);
        }
        if (path.toFile().exists()) {
            LOG.debug("RocksDB path found: {}, opening db from it.", (Object)path);
            return path;
        }
        LOG.debug("RocksDB path: {} not found, attempting to use fallback", (Object)path);
        File configLocation = DBConfigFromFile.getConfigLocation();
        if (configLocation != null && StringUtils.isNotBlank((CharSequence)configLocation.toString())) {
            Path fallbackPath = Paths.get(configLocation.toString(), DBConfigFromFile.getOptionsFileNameFromDB(path.toString()));
            LOG.debug("Fallback path found: {}", (Object)path);
            return fallbackPath;
        }
        LOG.info("No RocksDB path found");
        return Paths.get("", new String[0]);
    }
}

