/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class BooleanConstantNode
extends ConstantNode {
    boolean booleanValue;
    boolean unknownValue;

    BooleanConstantNode(ContextManager contextManager) throws StandardException {
        super(TypeId.BOOLEAN_ID, true, 1, contextManager);
        this.setValue(null);
    }

    BooleanConstantNode(boolean bl, ContextManager contextManager) throws StandardException {
        super(TypeId.BOOLEAN_ID, false, 1, contextManager);
        super.setValue(new SQLBoolean(bl));
        this.booleanValue = bl;
    }

    BooleanConstantNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        super(typeId, true, 0, contextManager);
        this.unknownValue = true;
    }

    @Override
    Object getConstantValueAsObject() {
        return this.booleanValue ? Boolean.TRUE : Boolean.FALSE;
    }

    String getValueAsString() {
        if (this.booleanValue) {
            return "true";
        }
        return "false";
    }

    @Override
    boolean isBooleanTrue() {
        return this.booleanValue && !this.unknownValue;
    }

    @Override
    boolean isBooleanFalse() {
        return !this.booleanValue && !this.unknownValue;
    }

    @Override
    public double selectivity(Optimizable optimizable) {
        if (this.isBooleanTrue()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    ValueNode eliminateNots(boolean bl) {
        if (!bl) {
            return this;
        }
        this.booleanValue = !this.booleanValue;
        super.setValue(new SQLBoolean(this.booleanValue));
        return this;
    }

    @Override
    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) {
        methodBuilder.push(this.booleanValue);
    }

    @Override
    void setValue(DataValueDescriptor dataValueDescriptor) {
        super.setValue(dataValueDescriptor);
        this.unknownValue = true;
        try {
            if (dataValueDescriptor != null && dataValueDescriptor.isNotNull().getBoolean()) {
                this.booleanValue = dataValueDescriptor.getBoolean();
                this.unknownValue = false;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }
}

