/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks.updater;

import com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.recon.schema.generated.tables.daos.ReconTaskStatusDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.ReconTaskStatus;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconTaskStatusUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(ReconTaskStatusUpdater.class);
    private ReconTaskStatus reconTaskStatus;
    private ReconTaskStatusDao reconTaskStatusDao;
    private String taskName;

    @VisibleForTesting
    public ReconTaskStatusUpdater(ReconTaskStatusDao reconTaskStatusDao, String taskName) {
        this.taskName = taskName;
        this.reconTaskStatusDao = reconTaskStatusDao;
        this.reconTaskStatus = new ReconTaskStatus(taskName, 0L, 0L, 0, 0);
    }

    public ReconTaskStatusUpdater(ReconTaskStatusDao reconTaskStatusDao, ReconTaskStatus task) {
        this.taskName = task.getTaskName();
        this.reconTaskStatusDao = reconTaskStatusDao;
        this.reconTaskStatus = new ReconTaskStatus(this.taskName, task.getLastUpdatedTimestamp(), task.getLastUpdatedSeqNumber(), task.getLastTaskRunStatus(), task.getIsCurrentTaskRunning());
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
        this.reconTaskStatus.setTaskName(taskName);
    }

    public void setLastUpdatedSeqNumber(long lastUpdatedSeqNumber) {
        this.reconTaskStatus.setLastUpdatedSeqNumber(lastUpdatedSeqNumber);
    }

    public void setLastUpdatedTimestamp(long lastUpdatedTimestamp) {
        this.reconTaskStatus.setLastUpdatedTimestamp(lastUpdatedTimestamp);
    }

    public void setLastTaskRunStatus(int lastTaskRunStatus) {
        this.reconTaskStatus.setLastTaskRunStatus(lastTaskRunStatus);
    }

    public void setIsCurrentTaskRunning(int isCurrentTaskRunning) {
        this.reconTaskStatus.setIsCurrentTaskRunning(isCurrentTaskRunning);
    }

    public Long getLastUpdatedSeqNumber() {
        return this.reconTaskStatus.getLastUpdatedSeqNumber();
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void recordRunStart() {
        try {
            this.reconTaskStatus.setIsCurrentTaskRunning(1);
            this.reconTaskStatus.setLastUpdatedTimestamp(System.currentTimeMillis());
            this.updateDetails();
        }
        catch (DataAccessException e) {
            LOG.error("Failed to update table for start of task: {}", (Object)this.reconTaskStatus.getTaskName());
        }
    }

    public void recordRunCompletion() {
        try {
            this.reconTaskStatus.setIsCurrentTaskRunning(0);
            this.reconTaskStatus.setLastUpdatedTimestamp(System.currentTimeMillis());
            this.updateDetails();
        }
        catch (DataAccessException e) {
            LOG.error("Failed to update table for task: {}", (Object)this.reconTaskStatus.getTaskName());
        }
    }

    public void updateDetails() {
        if (!this.reconTaskStatusDao.existsById(this.taskName)) {
            this.reconTaskStatusDao.insert(this.reconTaskStatus);
            LOG.info("Registered Task: {}", (Object)this.taskName);
        } else {
            this.reconTaskStatusDao.update(this.reconTaskStatus);
        }
    }
}

