/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.util.mxConstants;
import java.awt.Color;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class mxHtmlColor {
    private static final Logger log = Logger.getLogger(mxHtmlColor.class.getName());
    protected static HashMap<String, Color> htmlColors = new HashMap();
    protected static final Pattern rgbRegex = Pattern.compile("rgba?\\([^)]*\\)", 2);

    public static String hexString(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static String getHexColorString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | color.getAlpha() << 24);
    }

    public static Color parseColor(String str) throws NumberFormatException {
        return mxHtmlColor.parseColor(str, 1.0);
    }

    public static Color parseColor(String str, double alpha) throws NumberFormatException {
        if (str == null || str.equals(mxConstants.NONE)) {
            return null;
        }
        if (rgbRegex.matcher(str).matches()) {
            return mxHtmlColor.parseRgb(str);
        }
        if (!str.startsWith("#")) {
            Color result = htmlColors.get(str);
            if (result != null) {
                return result;
            }
        } else if (str.length() == 4) {
            str = new String(new char[]{'#', str.charAt(1), str.charAt(1), str.charAt(2), str.charAt(2), str.charAt(3), str.charAt(3)});
        }
        int value = 0;
        try {
            String tmp = str;
            if (tmp.startsWith("#")) {
                tmp = tmp.substring(1);
            }
            value = (int)(Long.parseLong(tmp, 16) | (long)((int)(alpha * 255.0) << 24));
        }
        catch (NumberFormatException nfe) {
            try {
                value = Long.decode(str).intValue();
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, "Failed to parse color value", e);
            }
        }
        return alpha < 1.0 ? new Color(value, true) : new Color(value);
    }

    protected static Color parseRgb(String rgbString) {
        String[] values = rgbString.split("[,()]");
        String red = values[1].trim();
        String green = values[2].trim();
        String blue = values[3].trim();
        String alpha = "1.0";
        if (values.length >= 5) {
            alpha = values[4].trim();
        }
        return new Color(mxHtmlColor.parseValue(red, 255), mxHtmlColor.parseValue(green, 255), mxHtmlColor.parseValue(blue, 255), mxHtmlColor.parseAlpha(alpha));
    }

    protected static float parseValue(String val, int max) {
        if (val.endsWith("%")) {
            return (float)(mxHtmlColor.parsePercent(val) * (double)max / (double)max);
        }
        return Integer.parseInt(val) / max;
    }

    protected static double parsePercent(String perc) {
        return (double)Integer.parseInt(perc.substring(0, perc.length() - 1)) / 100.0;
    }

    protected static float parseAlpha(String alpha) {
        return Float.parseFloat(alpha);
    }

    static {
        htmlColors.put("aliceblue", mxHtmlColor.parseColor("#F0F8FF"));
        htmlColors.put("antiquewhite", mxHtmlColor.parseColor("#FAEBD7"));
        htmlColors.put("aqua", mxHtmlColor.parseColor("#00FFFF"));
        htmlColors.put("aquamarine", mxHtmlColor.parseColor("#7FFFD4"));
        htmlColors.put("azure", mxHtmlColor.parseColor("#F0FFFF"));
        htmlColors.put("beige", mxHtmlColor.parseColor("#F5F5DC"));
        htmlColors.put("bisque", mxHtmlColor.parseColor("#FFE4C4"));
        htmlColors.put("black", mxHtmlColor.parseColor("#000000"));
        htmlColors.put("blanchedalmond", mxHtmlColor.parseColor("#FFEBCD"));
        htmlColors.put("blue", mxHtmlColor.parseColor("#0000FF"));
        htmlColors.put("blueviolet", mxHtmlColor.parseColor("#8A2BE2"));
        htmlColors.put("brown", mxHtmlColor.parseColor("#A52A2A"));
        htmlColors.put("burlywood", mxHtmlColor.parseColor("#DEB887"));
        htmlColors.put("cadetblue", mxHtmlColor.parseColor("#5F9EA0"));
        htmlColors.put("chartreuse", mxHtmlColor.parseColor("#7FFF00"));
        htmlColors.put("chocolate", mxHtmlColor.parseColor("#D2691E"));
        htmlColors.put("coral", mxHtmlColor.parseColor("#FF7F50"));
        htmlColors.put("cornflowerblue", mxHtmlColor.parseColor("#6495ED"));
        htmlColors.put("cornsilk", mxHtmlColor.parseColor("#FFF8DC"));
        htmlColors.put("crimson", mxHtmlColor.parseColor("#DC143C"));
        htmlColors.put("cyan", mxHtmlColor.parseColor("#00FFFF"));
        htmlColors.put("darkblue", mxHtmlColor.parseColor("#00008B"));
        htmlColors.put("darkcyan", mxHtmlColor.parseColor("#008B8B"));
        htmlColors.put("darkgoldenrod", mxHtmlColor.parseColor("#B8860B"));
        htmlColors.put("darkgray", mxHtmlColor.parseColor("#A9A9A9"));
        htmlColors.put("darkgrey", mxHtmlColor.parseColor("#A9A9A9"));
        htmlColors.put("darkgreen", mxHtmlColor.parseColor("#006400"));
        htmlColors.put("darkkhaki", mxHtmlColor.parseColor("#BDB76B"));
        htmlColors.put("darkmagenta", mxHtmlColor.parseColor("#8B008B"));
        htmlColors.put("darkolivegreen", mxHtmlColor.parseColor("#556B2F"));
        htmlColors.put("darkorange", mxHtmlColor.parseColor("#FF8C00"));
        htmlColors.put("darkorchid", mxHtmlColor.parseColor("#9932CC"));
        htmlColors.put("darkred", mxHtmlColor.parseColor("#8B0000"));
        htmlColors.put("darksalmon", mxHtmlColor.parseColor("#E9967A"));
        htmlColors.put("darkseagreen", mxHtmlColor.parseColor("#8FBC8F"));
        htmlColors.put("darkslateblue", mxHtmlColor.parseColor("#483D8B"));
        htmlColors.put("darkslategray", mxHtmlColor.parseColor("#2F4F4F"));
        htmlColors.put("darkslategrey", mxHtmlColor.parseColor("#2F4F4F"));
        htmlColors.put("darkturquoise", mxHtmlColor.parseColor("#00CED1"));
        htmlColors.put("darkviolet", mxHtmlColor.parseColor("#9400D3"));
        htmlColors.put("deeppink", mxHtmlColor.parseColor("#FF1493"));
        htmlColors.put("deepskyblue", mxHtmlColor.parseColor("#00BFFF"));
        htmlColors.put("dimgray", mxHtmlColor.parseColor("#696969"));
        htmlColors.put("dimgrey", mxHtmlColor.parseColor("#696969"));
        htmlColors.put("dodgerblue", mxHtmlColor.parseColor("#1E90FF"));
        htmlColors.put("firebrick", mxHtmlColor.parseColor("#B22222"));
        htmlColors.put("floralwhite", mxHtmlColor.parseColor("#FFFAF0"));
        htmlColors.put("forestgreen", mxHtmlColor.parseColor("#228B22"));
        htmlColors.put("fuchsia", mxHtmlColor.parseColor("#FF00FF"));
        htmlColors.put("gainsboro", mxHtmlColor.parseColor("#DCDCDC"));
        htmlColors.put("ghostwhite", mxHtmlColor.parseColor("#F8F8FF"));
        htmlColors.put("gold", mxHtmlColor.parseColor("#FFD700"));
        htmlColors.put("goldenrod", mxHtmlColor.parseColor("#DAA520"));
        htmlColors.put("gray", mxHtmlColor.parseColor("#808080"));
        htmlColors.put("grey", mxHtmlColor.parseColor("#808080"));
        htmlColors.put("green", mxHtmlColor.parseColor("#008000"));
        htmlColors.put("greenyellow", mxHtmlColor.parseColor("#ADFF2F"));
        htmlColors.put("honeydew", mxHtmlColor.parseColor("#F0FFF0"));
        htmlColors.put("hotpink", mxHtmlColor.parseColor("#FF69B4"));
        htmlColors.put("indianred ", mxHtmlColor.parseColor("#CD5C5C"));
        htmlColors.put("indigo ", mxHtmlColor.parseColor("#4B0082"));
        htmlColors.put("ivory", mxHtmlColor.parseColor("#FFFFF0"));
        htmlColors.put("khaki", mxHtmlColor.parseColor("#F0E68C"));
        htmlColors.put("lavender", mxHtmlColor.parseColor("#E6E6FA"));
        htmlColors.put("lavenderblush", mxHtmlColor.parseColor("#FFF0F5"));
        htmlColors.put("lawngreen", mxHtmlColor.parseColor("#7CFC00"));
        htmlColors.put("lemonchiffon", mxHtmlColor.parseColor("#FFFACD"));
        htmlColors.put("lightblue", mxHtmlColor.parseColor("#ADD8E6"));
        htmlColors.put("lightcoral", mxHtmlColor.parseColor("#F08080"));
        htmlColors.put("lightcyan", mxHtmlColor.parseColor("#E0FFFF"));
        htmlColors.put("lightgoldenrodyellow", mxHtmlColor.parseColor("#FAFAD2"));
        htmlColors.put("lightgray", mxHtmlColor.parseColor("#D3D3D3"));
        htmlColors.put("lightgrey", mxHtmlColor.parseColor("#D3D3D3"));
        htmlColors.put("lightgreen", mxHtmlColor.parseColor("#90EE90"));
        htmlColors.put("lightpink", mxHtmlColor.parseColor("#FFB6C1"));
        htmlColors.put("lightsalmon", mxHtmlColor.parseColor("#FFA07A"));
        htmlColors.put("lightseagreen", mxHtmlColor.parseColor("#20B2AA"));
        htmlColors.put("lightskyblue", mxHtmlColor.parseColor("#87CEFA"));
        htmlColors.put("lightslategray", mxHtmlColor.parseColor("#778899"));
        htmlColors.put("lightslategrey", mxHtmlColor.parseColor("#778899"));
        htmlColors.put("lightsteelblue", mxHtmlColor.parseColor("#B0C4DE"));
        htmlColors.put("lightyellow", mxHtmlColor.parseColor("#FFFFE0"));
        htmlColors.put("lime", mxHtmlColor.parseColor("#00FF00"));
        htmlColors.put("limegreen", mxHtmlColor.parseColor("#32CD32"));
        htmlColors.put("linen", mxHtmlColor.parseColor("#FAF0E6"));
        htmlColors.put("magenta", mxHtmlColor.parseColor("#FF00FF"));
        htmlColors.put("maroon", mxHtmlColor.parseColor("#800000"));
        htmlColors.put("mediumaquamarine", mxHtmlColor.parseColor("#66CDAA"));
        htmlColors.put("mediumblue", mxHtmlColor.parseColor("#0000CD"));
        htmlColors.put("mediumorchid", mxHtmlColor.parseColor("#BA55D3"));
        htmlColors.put("mediumpurple", mxHtmlColor.parseColor("#9370DB"));
        htmlColors.put("mediumseagreen", mxHtmlColor.parseColor("#3CB371"));
        htmlColors.put("mediumslateblue", mxHtmlColor.parseColor("#7B68EE"));
        htmlColors.put("mediumspringgreen", mxHtmlColor.parseColor("#00FA9A"));
        htmlColors.put("mediumturquoise", mxHtmlColor.parseColor("#48D1CC"));
        htmlColors.put("mediumvioletred", mxHtmlColor.parseColor("#C71585"));
        htmlColors.put("midnightblue", mxHtmlColor.parseColor("#191970"));
        htmlColors.put("mintcream", mxHtmlColor.parseColor("#F5FFFA"));
        htmlColors.put("mistyrose", mxHtmlColor.parseColor("#FFE4E1"));
        htmlColors.put("moccasin", mxHtmlColor.parseColor("#FFE4B5"));
        htmlColors.put("navajowhite", mxHtmlColor.parseColor("#FFDEAD"));
        htmlColors.put("navy", mxHtmlColor.parseColor("#000080"));
        htmlColors.put("oldlace", mxHtmlColor.parseColor("#FDF5E6"));
        htmlColors.put("olive", mxHtmlColor.parseColor("#808000"));
        htmlColors.put("olivedrab", mxHtmlColor.parseColor("#6B8E23"));
        htmlColors.put("orange", mxHtmlColor.parseColor("#FFA500"));
        htmlColors.put("orangered", mxHtmlColor.parseColor("#FF4500"));
        htmlColors.put("orchid", mxHtmlColor.parseColor("#DA70D6"));
        htmlColors.put("palegoldenrod", mxHtmlColor.parseColor("#EEE8AA"));
        htmlColors.put("palegreen", mxHtmlColor.parseColor("#98FB98"));
        htmlColors.put("paleturquoise", mxHtmlColor.parseColor("#AFEEEE"));
        htmlColors.put("palevioletred", mxHtmlColor.parseColor("#DB7093"));
        htmlColors.put("papayawhip", mxHtmlColor.parseColor("#FFEFD5"));
        htmlColors.put("peachpuff", mxHtmlColor.parseColor("#FFDAB9"));
        htmlColors.put("peru", mxHtmlColor.parseColor("#CD853F"));
        htmlColors.put("pink", mxHtmlColor.parseColor("#FFC0CB"));
        htmlColors.put("plum", mxHtmlColor.parseColor("#DDA0DD"));
        htmlColors.put("powderblue", mxHtmlColor.parseColor("#B0E0E6"));
        htmlColors.put("purple", mxHtmlColor.parseColor("#800080"));
        htmlColors.put("red", mxHtmlColor.parseColor("#FF0000"));
        htmlColors.put("rosybrown", mxHtmlColor.parseColor("#BC8F8F"));
        htmlColors.put("royalblue", mxHtmlColor.parseColor("#4169E1"));
        htmlColors.put("saddlebrown", mxHtmlColor.parseColor("#8B4513"));
        htmlColors.put("salmon", mxHtmlColor.parseColor("#FA8072"));
        htmlColors.put("sandybrown", mxHtmlColor.parseColor("#F4A460"));
        htmlColors.put("seagreen", mxHtmlColor.parseColor("#2E8B57"));
        htmlColors.put("seashell", mxHtmlColor.parseColor("#FFF5EE"));
        htmlColors.put("sienna", mxHtmlColor.parseColor("#A0522D"));
        htmlColors.put("silver", mxHtmlColor.parseColor("#C0C0C0"));
        htmlColors.put("skyblue", mxHtmlColor.parseColor("#87CEEB"));
        htmlColors.put("slateblue", mxHtmlColor.parseColor("#6A5ACD"));
        htmlColors.put("slategray", mxHtmlColor.parseColor("#708090"));
        htmlColors.put("slategrey", mxHtmlColor.parseColor("#708090"));
        htmlColors.put("snow", mxHtmlColor.parseColor("#FFFAFA"));
        htmlColors.put("springgreen", mxHtmlColor.parseColor("#00FF7F"));
        htmlColors.put("steelblue", mxHtmlColor.parseColor("#4682B4"));
        htmlColors.put("tan", mxHtmlColor.parseColor("#D2B48C"));
        htmlColors.put("teal", mxHtmlColor.parseColor("#008080"));
        htmlColors.put("thistle", mxHtmlColor.parseColor("#D8BFD8"));
        htmlColors.put("tomato", mxHtmlColor.parseColor("#FF6347"));
        htmlColors.put("turquoise", mxHtmlColor.parseColor("#40E0D0"));
        htmlColors.put("violet", mxHtmlColor.parseColor("#EE82EE"));
        htmlColors.put("wheat", mxHtmlColor.parseColor("#F5DEB3"));
        htmlColors.put("white", mxHtmlColor.parseColor("#FFFFFF"));
        htmlColors.put("whitesmoke", mxHtmlColor.parseColor("#F5F5F5"));
        htmlColors.put("yellow", mxHtmlColor.parseColor("#FFFF00"));
        htmlColors.put("yellowgreen", mxHtmlColor.parseColor("#9ACD32"));
    }
}

