/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@InterfaceAudience.Private
@Metrics(about="Datanode container scanner metrics", context="dfs")
public abstract class AbstractContainerScannerMetrics {
    private final String name;
    private final MetricsSystem ms;
    @Metric(value={"number of containers scanned in the current iteration"})
    private MutableGaugeInt numContainersScanned;
    @Metric(value={"number of unhealthy containers found in the current iteration"})
    private MutableGaugeInt numUnHealthyContainers;
    @Metric(value={"number of iterations of scanner completed since the restart"})
    private MutableCounterInt numScanIterations;

    public AbstractContainerScannerMetrics(String name, MetricsSystem ms) {
        this.name = name;
        this.ms = ms;
    }

    public int getNumContainersScanned() {
        return this.numContainersScanned.value();
    }

    public void incNumContainersScanned() {
        this.numContainersScanned.incr();
    }

    public void resetNumContainersScanned() {
        this.numContainersScanned.decr(this.getNumContainersScanned());
    }

    public int getNumUnHealthyContainers() {
        return this.numUnHealthyContainers.value();
    }

    public void incNumUnHealthyContainers() {
        this.numUnHealthyContainers.incr();
    }

    public void resetNumUnhealthyContainers() {
        this.numUnHealthyContainers.decr(this.getNumUnHealthyContainers());
    }

    public int getNumScanIterations() {
        return this.numScanIterations.value();
    }

    public void incNumScanIterations() {
        this.numScanIterations.incr();
    }

    public void unregister() {
        this.ms.unregisterSource(this.name);
    }

    public String getName() {
        return this.name;
    }
}

