/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.checksum.DNContainerOperationClient;
import org.apache.hadoop.ozone.container.checksum.ReconcileContainerTask;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.protocol.commands.ReconcileContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ReconcileContainerCommandHandler
implements CommandHandler {
    private final ReplicationSupervisor supervisor;
    private final DNContainerOperationClient dnClient;
    private String metricsName;

    public ReconcileContainerCommandHandler(ReplicationSupervisor supervisor, DNContainerOperationClient dnClient) {
        this.supervisor = supervisor;
        this.dnClient = dnClient;
    }

    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        ReconcileContainerCommand reconcileCommand = (ReconcileContainerCommand)command;
        ReconcileContainerTask task = new ReconcileContainerTask(container.getController(), this.dnClient, reconcileCommand);
        if (this.metricsName == null) {
            this.metricsName = task.getMetricName();
        }
        this.supervisor.addTask(task);
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.reconcileContainerCommand;
    }

    @Override
    public int getQueuedCount() {
        return this.metricsName == null ? 0 : (int)this.supervisor.getReplicationQueuedCount(this.metricsName);
    }

    @Override
    public int getInvocationCount() {
        return this.metricsName == null ? 0 : (int)this.supervisor.getReplicationRequestCount(this.metricsName);
    }

    @Override
    public long getAverageRunTime() {
        return this.metricsName == null ? 0L : (long)((int)this.supervisor.getReplicationRequestAvgTime(this.metricsName));
    }

    @Override
    public long getTotalRunTime() {
        return this.metricsName == null ? 0L : this.supervisor.getReplicationRequestTotalTime(this.metricsName);
    }

    public String getMetricsName() {
        return this.metricsName;
    }
}

