/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.ExpiredOpenKeys;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.ListOpenFilesResult;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.HierarchicalResourceLockManager;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.snapshot.ListSnapshotResponse;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.ozone.compaction.log.CompactionLogEntry;

public interface OMMetadataManager
extends DBStoreHAManager,
AutoCloseable {
    public void start(OzoneConfiguration var1) throws IOException;

    public void stop() throws Exception;

    @VisibleForTesting
    public DBStore getStore();

    public IOzoneManagerLock getLock();

    public HierarchicalResourceLockManager getHierarchicalLockManager();

    public long getOmEpoch();

    public String getVolumeKey(String var1);

    public String getUserKey(String var1);

    public String getBucketKey(String var1, String var2);

    public String getBucketKeyPrefix(String var1, String var2);

    public String getBucketKeyPrefixFSO(String var1, String var2) throws IOException;

    public VolumeBucketId getVolumeBucketIdPairFSO(String var1) throws IOException;

    public String getOzoneKey(String var1, String var2, String var3);

    public String getOzoneKeyFSO(String var1, String var2, String var3) throws IOException;

    public String getOzoneDirKey(String var1, String var2, String var3);

    default public String getOpenKey(String volume, String bucket, String key, long id) {
        return this.getOpenKey(volume, bucket, key, String.valueOf(id));
    }

    public String getOpenKey(String var1, String var2, String var3, String var4);

    public static long getClientIDFromOpenKeyDBKey(String dbOpenKeyName) {
        int lastPrefix = dbOpenKeyName.lastIndexOf("/");
        String clientIdString = dbOpenKeyName.substring(lastPrefix + 1);
        return Long.parseLong(clientIdString);
    }

    public boolean isVolumeEmpty(String var1) throws IOException;

    public boolean isBucketEmpty(String var1, String var2) throws IOException;

    public List<OmBucketInfo> listBuckets(String var1, String var2, String var3, int var4, boolean var5) throws IOException;

    public ListOpenFilesResult listOpenFiles(BucketLayout var1, int var2, String var3, boolean var4, String var5) throws IOException;

    public ListKeysResult listKeys(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public SnapshotInfo getSnapshotInfo(String var1, String var2, String var3) throws IOException;

    public ListSnapshotResponse listSnapshot(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public List<OmVolumeArgs> listVolumes(String var1, String var2, String var3, int var4) throws IOException;

    public ExpiredOpenKeys getExpiredOpenKeys(Duration var1, int var2, BucketLayout var3, Duration var4) throws IOException;

    public List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> getExpiredMultipartUploads(Duration var1, int var2) throws IOException;

    public Table<String, OzoneManagerStorageProtos.PersistedUserVolumeInfo> getUserTable();

    public Table<String, OmVolumeArgs> getVolumeTable();

    public Table<String, OmBucketInfo> getBucketTable();

    public Table<String, OmKeyInfo> getKeyTable(BucketLayout var1);

    public Table<String, OmKeyInfo> getFileTable();

    public Table<String, RepeatedOmKeyInfo> getDeletedTable();

    public Table<String, OmKeyInfo> getOpenKeyTable(BucketLayout var1);

    public Table<OzoneTokenIdentifier, Long> getDelegationTokenTable();

    public Table<String, OmPrefixInfo> getPrefixTable();

    public String getMultipartKey(String var1, String var2, String var3, String var4);

    public String getMultipartKeyFSO(String var1, String var2, String var3, String var4) throws IOException;

    public Table<String, OmMultipartKeyInfo> getMultipartInfoTable();

    public Table<String, TransactionInfo> getTransactionInfoTable();

    public Table<String, OmDBAccessIdInfo> getTenantAccessIdTable();

    public Table<String, OmDBUserPrincipalInfo> getPrincipalToAccessIdsTable();

    public Table<String, OmDBTenantState> getTenantStateTable();

    public Table<String, SnapshotInfo> getSnapshotInfoTable();

    public Table<String, String> getSnapshotRenamedTable();

    public Table<String, CompactionLogEntry> getCompactionLogTable();

    public Table<String, String> getMetaTable();

    public <KEY, VALUE> long countRowsInTable(Table<KEY, VALUE> var1) throws IOException;

    public <KEY, VALUE> long countEstimatedRowsInTable(Table<KEY, VALUE> var1) throws IOException;

    public List<OmMultipartUpload> getMultipartUploadKeys(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7) throws IOException;

    public Table<String, OmDirectoryInfo> getDirectoryTable();

    public Table getTable(String var1);

    public Map<String, Table> listTables();

    public Set<String> listTableNames();

    public Iterator<Map.Entry<CacheKey<String>, CacheValue<OmBucketInfo>>> getBucketIterator();

    public TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getKeyIterator() throws IOException;

    public String getOzonePathKey(long var1, long var3, long var5, String var7);

    default public String getOzonePathKey(long volumeId, long bucketId, OmDirectoryInfo dir) {
        return this.getOzonePathKey(volumeId, bucketId, dir.getParentObjectID(), dir.getName());
    }

    public String getOzoneDeletePathKey(long var1, String var3);

    public String getOzoneDeletePathDirKey(String var1);

    default public String getOpenFileName(long volumeId, long bucketId, long parentObjectId, String fileName, long id) {
        return this.getOpenFileName(volumeId, bucketId, parentObjectId, fileName, String.valueOf(id));
    }

    public String getOpenFileName(long var1, long var3, long var5, String var7, String var8);

    public String getRenameKey(String var1, String var2, long var3);

    public String[] splitRenameKey(String var1);

    public String getMultipartKey(long var1, long var3, long var5, String var7, String var8);

    public Table<String, OmKeyInfo> getDeletedDirTable();

    public long getVolumeId(String var1) throws IOException;

    public long getBucketId(String var1, String var2) throws IOException;

    public List<BlockGroup> getBlocksForKeyDelete(String var1) throws IOException;

    public boolean containsIncompleteMPUs(String var1, String var2) throws IOException;

    public static class VolumeBucketId {
        private final long volumeId;
        private final long bucketId;

        public VolumeBucketId(long volumeId, long bucketId) {
            this.volumeId = volumeId;
            this.bucketId = bucketId;
        }

        public long getBucketId() {
            return this.bucketId;
        }

        public long getVolumeId() {
            return this.volumeId;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof VolumeBucketId)) {
                return false;
            }
            VolumeBucketId that = (VolumeBucketId)o;
            return this.volumeId == that.volumeId && this.bucketId == that.bucketId;
        }

        public int hashCode() {
            return Objects.hash(this.volumeId, this.bucketId);
        }
    }
}

