/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.reconfig;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

final class ReconfigureSubCommandUtil {
    private ReconfigureSubCommandUtil() {
    }

    public static ReconfigureProtocol getSingleNodeReconfigureProxy(HddsProtos.NodeType nodeType, String address) throws IOException {
        OzoneConfiguration ozoneConf = new OzoneConfiguration();
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        InetSocketAddress nodeAddr = NetUtils.createSocketAddr((String)address);
        return new ReconfigureProtocolClientSideTranslatorPB(nodeType, nodeAddr, user, ozoneConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void parallelExecute(ExecutorService executorService, List<T> nodes, BiConsumer<HddsProtos.NodeType, T> operation) {
        AtomicInteger successCount = new AtomicInteger();
        AtomicInteger failCount = new AtomicInteger();
        if (nodes != null) {
            block6: {
                for (Object node : nodes) {
                    executorService.submit(() -> {
                        try {
                            operation.accept(HddsProtos.NodeType.DATANODE, node);
                            successCount.incrementAndGet();
                        }
                        catch (Exception e) {
                            failCount.incrementAndGet();
                            e.printStackTrace(System.out);
                        }
                    });
                }
                executorService.shutdown();
                try {
                    if (executorService.awaitTermination(3L, TimeUnit.MINUTES)) break block6;
                    System.out.println("Couldn't terminate executor in 180s.");
                    executorService.shutdownNow();
                }
                catch (InterruptedException e) {
                    try {
                        Thread.currentThread().interrupt();
                        System.out.println("Executor termination interrupted");
                    }
                    catch (Throwable throwable) {
                        System.out.printf("Reconfig successfully %d nodes, failure %d nodes.%n", successCount.get(), failCount.get());
                        throw throwable;
                    }
                    System.out.printf("Reconfig successfully %d nodes, failure %d nodes.%n", successCount.get(), failCount.get());
                }
            }
            System.out.printf("Reconfig successfully %d nodes, failure %d nodes.%n", successCount.get(), failCount.get());
        }
    }

    public static List<String> getAllOperableNodesClientRpcAddress(ScmClient scmClient) throws IOException {
        List nodes = scmClient.queryNode(HddsProtos.NodeOperationalState.IN_SERVICE, null, HddsProtos.QueryScope.CLUSTER, "");
        ArrayList<String> addresses = new ArrayList<String>();
        for (HddsProtos.Node node : nodes) {
            DatanodeDetails details = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID());
            if (node.getNodeStates(0).equals((Object)HddsProtos.NodeState.DEAD)) continue;
            DatanodeDetails.Port port = details.getPort(DatanodeDetails.Port.Name.CLIENT_RPC);
            if (port != null) {
                addresses.add(details.getIpAddress() + ":" + port.getValue());
                continue;
            }
            System.out.printf("host: %s(%s) %s port not found", details.getHostName(), details.getIpAddress(), DatanodeDetails.Port.Name.CLIENT_RPC.name());
        }
        return addresses;
    }
}

