/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import javax.enterprise.context.RequestScoped;

@RequestScoped
public class SignatureInfo {
    private Version version;
    private String date;
    private String dateTime;
    private String awsAccessId;
    private String signature;
    private String signedHeaders;
    private String credentialScope;
    private String algorithm;
    private boolean signPayload = true;
    private String unfilteredURI = null;
    private String stringToSign = null;

    public SignatureInfo() {
    }

    private SignatureInfo(Builder b) {
        this.initialize(b);
    }

    public void initialize(SignatureInfo signatureInfo) {
        this.initialize(new Builder(signatureInfo.getVersion()).setDate(signatureInfo.getDate()).setDateTime(signatureInfo.getDateTime()).setAwsAccessId(signatureInfo.getAwsAccessId()).setSignature(signatureInfo.getSignature()).setSignedHeaders(signatureInfo.getSignedHeaders()).setCredentialScope(signatureInfo.getCredentialScope()).setAlgorithm(signatureInfo.getAlgorithm()).setSignPayload(signatureInfo.isSignPayload()).setUnfilteredURI(signatureInfo.getUnfilteredURI()).setStringToSign(signatureInfo.getStringToSign()));
    }

    private void initialize(Builder b) {
        this.version = b.version;
        this.date = b.date;
        this.dateTime = b.dateTime;
        this.awsAccessId = b.awsAccessId;
        this.signature = b.signature;
        this.signedHeaders = b.signedHeaders;
        this.credentialScope = b.credentialScope;
        this.algorithm = b.algorithm;
        this.signPayload = b.signPayload;
        this.unfilteredURI = b.unfilteredURI;
        this.stringToSign = b.stringToSign;
    }

    public String getAwsAccessId() {
        return this.awsAccessId;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDate() {
        return this.date;
    }

    public String getSignedHeaders() {
        return this.signedHeaders;
    }

    public String getCredentialScope() {
        return this.credentialScope;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean isSignPayload() {
        return this.signPayload;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getUnfilteredURI() {
        return this.unfilteredURI;
    }

    public String getStringToSign() {
        return this.stringToSign;
    }

    public void setUnfilteredURI(String uri) {
        this.unfilteredURI = uri;
    }

    public void setStrToSign(String strToSign) {
        this.stringToSign = strToSign;
    }

    public static class Builder {
        private Version version;
        private String date = "";
        private String dateTime = "";
        private String awsAccessId = "";
        private String signature = "";
        private String signedHeaders = "";
        private String credentialScope = "";
        private String algorithm = "";
        private boolean signPayload = true;
        private String unfilteredURI = null;
        private String stringToSign = null;

        public Builder(Version version) {
            this.version = version;
        }

        public Builder setDate(String date) {
            this.date = date;
            return this;
        }

        public Builder setDateTime(String dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder setAwsAccessId(String awsAccessId) {
            this.awsAccessId = awsAccessId;
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder setSignedHeaders(String signedHeaders) {
            this.signedHeaders = signedHeaders;
            return this;
        }

        public Builder setCredentialScope(String credentialScope) {
            this.credentialScope = credentialScope;
            return this;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setSignPayload(boolean signPayload) {
            this.signPayload = signPayload;
            return this;
        }

        public Builder setUnfilteredURI(String uri) {
            this.unfilteredURI = uri;
            return this;
        }

        public Builder setStringToSign(String stringToSign) {
            this.stringToSign = stringToSign;
            return this;
        }

        public SignatureInfo build() {
            return new SignatureInfo(this);
        }
    }

    public static enum Version {
        NONE,
        V4,
        V2;

    }
}

