/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageLite;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.om.helpers.WithTags;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OmKeyInfo
extends WithParentObjectId
implements CopyObject<OmKeyInfo>,
WithTags {
    private static final Logger LOG = LoggerFactory.getLogger(OmKeyInfo.class);
    private static final Codec<OmKeyInfo> CODEC_TRUE = OmKeyInfo.newCodec(true);
    private static final Codec<OmKeyInfo> CODEC_FALSE = OmKeyInfo.newCodec(false);
    private static final String COMMITTED_KEY_DELETED_FLAG = "CKDEL";
    private final String volumeName;
    private final String bucketName;
    private String keyName;
    private long dataSize;
    private List<OmKeyLocationInfoGroup> keyLocationVersions;
    private final long creationTime;
    private long modificationTime;
    private ReplicationConfig replicationConfig;
    private FileEncryptionInfo encInfo;
    private final FileChecksum fileChecksum;
    private boolean isFile;
    private String fileName;
    private final String ownerName;
    private final CopyOnWriteArrayList<OzoneAcl> acls;
    private Map<String, String> tags;
    private Long expectedDataGeneration = null;

    private OmKeyInfo(Builder b) {
        super(b);
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.keyName = b.keyName;
        this.dataSize = b.dataSize;
        this.keyLocationVersions = b.omKeyLocationInfoGroups;
        this.creationTime = b.creationTime;
        this.modificationTime = b.modificationTime;
        this.replicationConfig = b.replicationConfig;
        this.encInfo = b.encInfo;
        this.acls = new CopyOnWriteArrayList(b.acls);
        this.fileChecksum = b.fileChecksum;
        this.fileName = b.fileName;
        this.isFile = b.isFile;
        this.ownerName = b.ownerName;
        this.tags = b.tags;
        this.expectedDataGeneration = b.expectedDataGeneration;
    }

    private static Codec<OmKeyInfo> newCodec(boolean ignorePipeline) {
        return new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.KeyInfo.getDefaultInstance()), OmKeyInfo::getFromProtobuf, k -> k.getProtobuf(ignorePipeline, ClientVersion.CURRENT_VERSION), OmKeyInfo.class);
    }

    public static Codec<OmKeyInfo> getCodec(boolean ignorePipeline) {
        LOG.debug("OmKeyInfo.getCodec ignorePipeline = {}", (Object)ignorePipeline);
        return ignorePipeline ? CODEC_TRUE : CODEC_FALSE;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getReplicatedSize() {
        return QuotaUtil.getReplicatedSize(this.getDataSize(), this.replicationConfig);
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setExpectedDataGeneration(Long generation) {
        this.expectedDataGeneration = generation;
    }

    public Long getExpectedDataGeneration() {
        return this.expectedDataGeneration;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setCommittedKeyDeletedFlag(boolean val) {
        if (val) {
            this.getMetadata().put(COMMITTED_KEY_DELETED_FLAG, "true");
        } else {
            this.getMetadata().remove(COMMITTED_KEY_DELETED_FLAG);
        }
    }

    public boolean isDeletedKeyCommitted() {
        return Boolean.parseBoolean(this.getMetadata().get(COMMITTED_KEY_DELETED_FLAG));
    }

    public long getGeneration() {
        return this.getUpdateID();
    }

    public synchronized OmKeyLocationInfoGroup getLatestVersionLocations() {
        return this.keyLocationVersions.isEmpty() ? null : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
    }

    public List<OmKeyLocationInfoGroup> getKeyLocationVersions() {
        return this.keyLocationVersions;
    }

    public void setKeyLocationVersions(List<OmKeyLocationInfoGroup> keyLocationVersions) {
        this.keyLocationVersions = keyLocationVersions;
    }

    public void setFile(boolean file) {
        this.isFile = file;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isHsync() {
        return this.getMetadata().containsKey("hsyncClientId");
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public List<OmKeyLocationInfo> updateLocationInfoList(List<OmKeyLocationInfo> locationInfoList, boolean isMpu) {
        return this.updateLocationInfoList(locationInfoList, isMpu, false);
    }

    public List<OmKeyLocationInfo> updateLocationInfoList(List<OmKeyLocationInfo> locationInfoList, boolean isMpu, boolean skipBlockIDCheck) {
        ArrayList<OmKeyLocationInfo> uncommittedBlocks;
        List updatedBlockLocations;
        long latestVersion = this.getLatestVersionLocations().getVersion();
        OmKeyLocationInfoGroup keyLocationInfoGroup = this.getLatestVersionLocations();
        keyLocationInfoGroup.setMultipartKey(isMpu);
        if (skipBlockIDCheck) {
            updatedBlockLocations = locationInfoList;
            uncommittedBlocks = new ArrayList();
        } else {
            Pair<List<OmKeyLocationInfo>, List<OmKeyLocationInfo>> verifiedResult = this.verifyAndGetKeyLocations(locationInfoList, keyLocationInfoGroup);
            updatedBlockLocations = (List)verifiedResult.getLeft();
            uncommittedBlocks = (List)verifiedResult.getRight();
        }
        keyLocationInfoGroup.removeBlocks(latestVersion);
        updatedBlockLocations.forEach(omKeyLocationInfo -> omKeyLocationInfo.setCreateVersion(latestVersion));
        keyLocationInfoGroup.addAll(latestVersion, updatedBlockLocations);
        return uncommittedBlocks;
    }

    private Pair<List<OmKeyLocationInfo>, List<OmKeyLocationInfo>> verifyAndGetKeyLocations(List<OmKeyLocationInfo> locationInfoList, OmKeyLocationInfoGroup keyLocationInfoGroup) {
        HashMap<ContainerBlockID, OmKeyLocationInfo> allocatedBlockLocations = new HashMap<ContainerBlockID, OmKeyLocationInfo>();
        for (OmKeyLocationInfo omKeyLocationInfo : keyLocationInfoGroup.getLocationList()) {
            ContainerBlockID existingBlockID = omKeyLocationInfo.getBlockID().getContainerBlockID();
            allocatedBlockLocations.put(existingBlockID, omKeyLocationInfo);
        }
        ArrayList<OmKeyLocationInfo> updatedBlockLocations = new ArrayList<OmKeyLocationInfo>();
        for (OmKeyLocationInfo modifiedLocationInfo : locationInfoList) {
            ContainerBlockID modifiedContainerBlockId = modifiedLocationInfo.getBlockID().getContainerBlockID();
            if (allocatedBlockLocations.containsKey(modifiedContainerBlockId)) {
                updatedBlockLocations.add(modifiedLocationInfo);
                allocatedBlockLocations.remove(modifiedContainerBlockId);
                continue;
            }
            LOG.warn("Unknown BlockLocation:{}, where the blockID of given location doesn't match with the stored/allocated block of keyName:{}", (Object)modifiedLocationInfo, (Object)this.keyName);
        }
        ArrayList arrayList = new ArrayList(allocatedBlockLocations.values());
        return Pair.of(updatedBlockLocations, arrayList);
    }

    public synchronized void appendNewBlocks(List<OmKeyLocationInfo> newLocationList, boolean updateTime) {
        if (this.keyLocationVersions.isEmpty()) {
            throw new IllegalStateException("Appending new blocks but keyLocationVersions is empty");
        }
        OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
        currentLatestVersion.appendNewBlocks(newLocationList);
        if (updateTime) {
            this.setModificationTime(Time.now());
        }
    }

    public synchronized long addNewVersion(List<OmKeyLocationInfo> newLocationList, boolean updateTime, boolean keepOldVersions) {
        long latestVersionNum;
        if (!keepOldVersions) {
            this.keyLocationVersions.clear();
        }
        if (this.keyLocationVersions.isEmpty()) {
            this.keyLocationVersions.add(new OmKeyLocationInfoGroup(0L, newLocationList));
            latestVersionNum = 0L;
        } else {
            OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
            OmKeyLocationInfoGroup newVersion = currentLatestVersion.generateNextVersion(newLocationList);
            this.keyLocationVersions.add(newVersion);
            latestVersionNum = newVersion.getVersion();
        }
        if (updateTime) {
            this.setModificationTime(Time.now());
        }
        return latestVersionNum;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.encInfo;
    }

    public List<OzoneAcl> getAcls() {
        return ImmutableList.copyOf(this.acls);
    }

    public boolean addAcl(OzoneAcl acl) {
        return OzoneAclUtil.addAcl(this.acls, acl);
    }

    public boolean removeAcl(OzoneAcl acl) {
        return OzoneAclUtil.removeAcl(this.acls, acl);
    }

    public boolean setAcls(List<OzoneAcl> newAcls) {
        return OzoneAclUtil.setAcl(this.acls, newAcls);
    }

    public void setReplicationConfig(ReplicationConfig repConfig) {
        this.replicationConfig = repConfig;
    }

    public FileChecksum getFileChecksum() {
        return this.fileChecksum;
    }

    public String toString() {
        return "OmKeyInfo{volumeName='" + this.volumeName + '\'' + ", bucketName='" + this.bucketName + '\'' + ", keyName='" + this.keyName + '\'' + ", dataSize=" + this.dataSize + ", keyLocationVersions=" + this.keyLocationVersions + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", replicationConfig=" + this.replicationConfig + ", encInfo=" + (this.encInfo == null ? "null" : "<REDACTED>") + ", fileChecksum=" + this.fileChecksum + ", isFile=" + this.isFile + ", fileName='" + this.fileName + '\'' + ", acls=" + this.acls + '}';
    }

    public OzoneManagerProtocolProtos.KeyInfo getProtobuf(int clientVersion) {
        return this.getProtobuf(false, clientVersion);
    }

    public OzoneManagerProtocolProtos.KeyInfo getNetworkProtobuf(int clientVersion, boolean latestVersion) {
        return this.getProtobuf(false, null, clientVersion, latestVersion);
    }

    public OzoneManagerProtocolProtos.KeyInfo getNetworkProtobuf(String fullKeyName, int clientVersion, boolean latestVersion) {
        return this.getProtobuf(false, fullKeyName, clientVersion, latestVersion);
    }

    public OzoneManagerProtocolProtos.KeyInfo getProtobuf(boolean ignorePipeline, int clientVersion) {
        return this.getProtobuf(ignorePipeline, null, clientVersion, false);
    }

    private OzoneManagerProtocolProtos.KeyInfo getProtobuf(boolean ignorePipeline, String fullKeyName, int clientVersion, boolean latestVersionBlocks) {
        long latestVersion = this.keyLocationVersions.isEmpty() ? -1L : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1).getVersion();
        ArrayList<OzoneManagerProtocolProtos.KeyLocationList> keyLocations = new ArrayList<OzoneManagerProtocolProtos.KeyLocationList>();
        if (!latestVersionBlocks) {
            for (OmKeyLocationInfoGroup locationInfoGroup : this.keyLocationVersions) {
                keyLocations.add(locationInfoGroup.getProtobuf(ignorePipeline, clientVersion));
            }
        } else if (latestVersion != -1L) {
            keyLocations.add(this.keyLocationVersions.get(this.keyLocationVersions.size() - 1).getProtobuf(ignorePipeline, clientVersion));
        }
        OzoneManagerProtocolProtos.KeyInfo.Builder kb = OzoneManagerProtocolProtos.KeyInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setDataSize(this.dataSize).setType(this.replicationConfig.getReplicationType());
        if (this.replicationConfig instanceof ECReplicationConfig) {
            kb.setEcReplicationConfig(((ECReplicationConfig)this.replicationConfig).toProto());
        } else {
            kb.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)this.replicationConfig));
        }
        kb.setLatestVersion(latestVersion).addAllKeyLocationList(keyLocations).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).addAllMetadata(KeyValueUtil.toProtobuf(this.getMetadata())).addAllTags(KeyValueUtil.toProtobuf(this.getTags())).addAllAcls(OzoneAclUtil.toProtobuf(this.acls)).setObjectID(this.getObjectID()).setUpdateID(this.getUpdateID()).setParentID(this.getParentObjectID());
        OzoneManagerProtocolProtos.FileChecksumProto fileChecksumProto = OMPBHelper.convert(this.fileChecksum);
        if (fileChecksumProto != null) {
            kb.setFileChecksum(fileChecksumProto);
        }
        if (StringUtils.isNotBlank((CharSequence)fullKeyName)) {
            kb.setKeyName(fullKeyName);
        } else {
            kb.setKeyName(this.keyName);
        }
        if (this.encInfo != null) {
            kb.setFileEncryptionInfo(OMPBHelper.convert(this.encInfo));
        }
        kb.setIsFile(this.isFile);
        if (this.expectedDataGeneration != null) {
            kb.setExpectedDataGeneration(this.expectedDataGeneration.longValue());
        }
        if (this.ownerName != null) {
            kb.setOwnerName(this.ownerName);
        }
        return kb.build();
    }

    public static OmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyInfo keyInfo) {
        if (keyInfo == null) {
            return null;
        }
        ArrayList<OmKeyLocationInfoGroup> omKeyLocationInfos = new ArrayList<OmKeyLocationInfoGroup>();
        for (OzoneManagerProtocolProtos.KeyLocationList keyLocationList : keyInfo.getKeyLocationListList()) {
            omKeyLocationInfos.add(OmKeyLocationInfoGroup.getFromProtobuf(keyLocationList));
        }
        Builder builder = ((Builder)new Builder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(keyInfo.getKeyName()).setOmKeyLocationInfos(omKeyLocationInfos).setDataSize(keyInfo.getDataSize()).setCreationTime(keyInfo.getCreationTime()).setModificationTime(keyInfo.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto((HddsProtos.ReplicationType)keyInfo.getType(), (HddsProtos.ReplicationFactor)keyInfo.getFactor(), (HddsProtos.ECReplicationConfig)keyInfo.getEcReplicationConfig())).addAllMetadata((Map)KeyValueUtil.getFromProtobuf(keyInfo.getMetadataList()))).addAllTags(KeyValueUtil.getFromProtobuf(keyInfo.getTagsList())).setFileEncryptionInfo(keyInfo.hasFileEncryptionInfo() ? OMPBHelper.convert(keyInfo.getFileEncryptionInfo()) : null).setAcls(OzoneAclUtil.fromProtobuf(keyInfo.getAclsList()));
        if (keyInfo.hasObjectID()) {
            builder.setObjectID(keyInfo.getObjectID());
        }
        if (keyInfo.hasUpdateID()) {
            builder.setUpdateID(keyInfo.getUpdateID());
        }
        if (keyInfo.hasParentID()) {
            builder.setParentObjectID(keyInfo.getParentID());
        }
        if (keyInfo.hasFileChecksum()) {
            FileChecksum fileChecksum = OMPBHelper.convert(keyInfo.getFileChecksum());
            builder.setFileChecksum(fileChecksum);
        }
        if (keyInfo.hasIsFile()) {
            builder.setFile(keyInfo.getIsFile());
        }
        if (keyInfo.hasExpectedDataGeneration()) {
            builder.setExpectedDataGeneration(keyInfo.getExpectedDataGeneration());
        }
        if (keyInfo.hasOwnerName()) {
            builder.setOwnerName(keyInfo.getOwnerName());
        }
        builder.setFileName(OzoneFSUtils.getFileName(keyInfo.getKeyName()));
        return builder.build();
    }

    @Override
    public String getObjectInfo() {
        return "OMKeyInfo{volume='" + this.volumeName + '\'' + ", bucket='" + this.bucketName + '\'' + ", key='" + this.keyName + '\'' + ", owner='" + this.ownerName + '\'' + ", dataSize='" + this.dataSize + '\'' + ", creationTime='" + this.creationTime + '\'' + ", objectID='" + this.getObjectID() + '\'' + ", parentID='" + this.getParentObjectID() + '\'' + ", replication='" + this.replicationConfig + '\'' + ", fileChecksum='" + this.fileChecksum + '}';
    }

    public boolean isKeyInfoSame(OmKeyInfo omKeyInfo, boolean checkPath, boolean checkKeyLocationVersions, boolean checkModificationTime, boolean checkUpdateID, boolean checkOwnerName) {
        boolean isEqual;
        boolean bl = isEqual = this.dataSize == omKeyInfo.dataSize && this.creationTime == omKeyInfo.creationTime && this.volumeName.equals(omKeyInfo.volumeName) && this.bucketName.equals(omKeyInfo.bucketName) && this.replicationConfig.equals((Object)omKeyInfo.replicationConfig) && Objects.equals(this.getMetadata(), omKeyInfo.getMetadata()) && Objects.equals(this.acls, omKeyInfo.acls) && Objects.equals(this.getTags(), omKeyInfo.getTags()) && this.getObjectID() == omKeyInfo.getObjectID();
        if (isEqual && checkUpdateID) {
            boolean bl2 = isEqual = this.getUpdateID() == omKeyInfo.getUpdateID();
        }
        if (isEqual && checkModificationTime) {
            boolean bl3 = isEqual = this.modificationTime == omKeyInfo.modificationTime;
        }
        if (isEqual && checkPath) {
            boolean bl4 = isEqual = this.getParentObjectID() == omKeyInfo.getParentObjectID() && this.keyName.equals(omKeyInfo.keyName);
        }
        if (isEqual && checkKeyLocationVersions) {
            isEqual = Objects.equals(this.keyLocationVersions, omKeyInfo.keyLocationVersions);
        }
        if (isEqual && checkOwnerName) {
            isEqual = Objects.equals(this.ownerName, omKeyInfo.ownerName);
        }
        return isEqual;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.isKeyInfoSame((OmKeyInfo)o, true, true, true, true, true);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName, this.keyName, this.getParentObjectID());
    }

    public OmKeyInfo copyObject() {
        Builder builder = new Builder(this).setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setOwnerName(this.ownerName).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setDataSize(this.dataSize).setReplicationConfig(this.replicationConfig).setFileEncryptionInfo(this.encInfo).setAcls(this.acls).setFileName(this.fileName).setFile(this.isFile);
        this.keyLocationVersions.forEach(keyLocationVersion -> builder.addOmKeyLocationInfoGroup(new OmKeyLocationInfoGroup(keyLocationVersion.getVersion(), keyLocationVersion.getLocationList(), keyLocationVersion.isMultipartKey())));
        if (this.getMetadata() != null) {
            this.getMetadata().forEach(builder::addMetadata);
        }
        if (this.getTags() != null) {
            this.getTags().forEach(builder::addTag);
        }
        if (this.fileChecksum != null) {
            builder.setFileChecksum(this.fileChecksum);
        }
        if (this.expectedDataGeneration != null) {
            builder.setExpectedDataGeneration(this.expectedDataGeneration);
        }
        return builder.build();
    }

    public void clearFileEncryptionInfo() {
        this.encInfo = null;
    }

    public void setFileEncryptionInfo(FileEncryptionInfo fileEncryptionInfo) {
        this.encInfo = fileEncryptionInfo;
    }

    public String getPath() {
        if (StringUtils.isBlank((CharSequence)this.getFileName())) {
            return this.getKeyName();
        }
        return this.getParentObjectID() + "/" + this.getFileName();
    }

    public boolean hasBlocks() {
        for (OmKeyLocationInfoGroup keyLocationList : this.getKeyLocationVersions()) {
            if (keyLocationList.getLocationListCount() == 0L) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyEmpty(@Nullable OmKeyInfo keyInfo) {
        if (keyInfo == null) {
            return true;
        }
        return !keyInfo.hasBlocks();
    }

    public static class Builder
    extends WithParentObjectId.Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private String ownerName;
        private long dataSize;
        private final List<OmKeyLocationInfoGroup> omKeyLocationInfoGroups = new ArrayList<OmKeyLocationInfoGroup>();
        private long creationTime;
        private long modificationTime;
        private ReplicationConfig replicationConfig;
        private FileEncryptionInfo encInfo;
        private final List<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        private String fileName;
        private FileChecksum fileChecksum;
        private boolean isFile;
        private final Map<String, String> tags = new HashMap<String, String>();
        private Long expectedDataGeneration = null;

        public Builder() {
        }

        public Builder(OmKeyInfo obj) {
            super(obj);
        }

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setOmKeyLocationInfos(List<OmKeyLocationInfoGroup> omKeyLocationInfoList) {
            if (omKeyLocationInfoList != null) {
                this.omKeyLocationInfoGroups.addAll(omKeyLocationInfoList);
            }
            return this;
        }

        public Builder addOmKeyLocationInfoGroup(OmKeyLocationInfoGroup omKeyLocationInfoGroup) {
            if (omKeyLocationInfoGroup != null) {
                this.omKeyLocationInfoGroups.add(omKeyLocationInfoGroup);
            }
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setModificationTime(long mTime) {
            this.modificationTime = mTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        @Override
        public Builder addMetadata(String key, String value) {
            super.addMetadata(key, value);
            return this;
        }

        @Override
        public Builder addAllMetadata(Map<String, String> newMetadata) {
            super.addAllMetadata(newMetadata);
            return this;
        }

        public Builder setFileEncryptionInfo(FileEncryptionInfo feInfo) {
            this.encInfo = feInfo;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        @Override
        public Builder setObjectID(long obId) {
            super.setObjectID(obId);
            return this;
        }

        @Override
        public Builder setUpdateID(long id) {
            super.setUpdateID(id);
            return this;
        }

        public Builder setFileName(String keyFileName) {
            this.fileName = keyFileName;
            return this;
        }

        @Override
        public Builder setParentObjectID(long parentID) {
            super.setParentObjectID(parentID);
            return this;
        }

        public Builder setFileChecksum(FileChecksum checksum) {
            this.fileChecksum = checksum;
            return this;
        }

        public Builder setFile(boolean isAFile) {
            this.isFile = isAFile;
            return this;
        }

        public Builder addTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder addAllTags(Map<String, String> keyTags) {
            this.tags.putAll(keyTags);
            return this;
        }

        public Builder setExpectedDataGeneration(Long existingGeneration) {
            this.expectedDataGeneration = existingGeneration;
            return this;
        }

        public OmKeyInfo build() {
            return new OmKeyInfo(this);
        }
    }
}

