/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.RenderContext;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.SQLDataType;

final class Limit
extends AbstractQueryPart {
    private static final long serialVersionUID = 2053741242981425602L;
    private static final Field<Integer> ZERO = DSL.zero();
    private static final Field<Integer> ONE = DSL.one();
    private static final Param<Integer> MAX = DSL.inline(Integer.MAX_VALUE);
    private Field<Integer> numberOfRows;
    private Field<Integer> numberOfRowsOrMax = MAX;
    private Field<Integer> offset;
    private Field<Integer> offsetOrZero = ZERO;
    private Field<Integer> offsetPlusOne = ONE;
    private boolean rendersParams;
    private boolean withTies;

    Limit() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        ParamType paramType = ctx.paramType();
        RenderContext.CastMode castMode = ctx.castMode();
        switch (ctx.dialect()) {
            case CUBRID: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.offsetOrZero).sql(", ").visit(this.numberOfRowsOrMax).castMode(castMode);
                break;
            }
            case FIREBIRD: 
            case FIREBIRD_2_5: 
            case FIREBIRD_3_0: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_ROWS).sql(' ').visit(this.getLowerRownum().add(DSL.inline((Object)1, SQLDataType.INTEGER))).sql(' ').visit(Keywords.K_TO).sql(' ').visit(this.getUpperRownum()).castMode(castMode);
                break;
            }
            case DERBY: {
                ctx.castMode(RenderContext.CastMode.NEVER);
                ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero).sql(' ').visit(Keywords.K_ROWS);
                if (!this.limitZero()) {
                    ctx.formatSeparator().visit(Keywords.K_FETCH_NEXT).sql(' ').visit(this.numberOfRows);
                    ctx.sql(' ').visit(this.withTies ? Keywords.K_ROWS_WITH_TIES : Keywords.K_ROWS_ONLY);
                }
                ctx.castMode(castMode);
                break;
            }
            case H2: 
            case MARIADB: 
            case MYSQL_5_7: 
            case MYSQL_8_0: 
            case MYSQL: 
            case SQLITE: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.numberOfRowsOrMax);
                if (!this.offsetZero()) {
                    ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
                }
                ctx.castMode(castMode);
                break;
            }
            default: {
                ctx.castMode(RenderContext.CastMode.NEVER);
                if (!this.limitZero()) {
                    ctx.formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.numberOfRows);
                }
                if (!this.offsetZero()) {
                    ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
                }
                ctx.castMode(castMode);
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final boolean limitZero() {
        return this.numberOfRows == null;
    }

    final boolean limitOne() {
        return !this.limitZero() && !this.withTies() && this.numberOfRows instanceof Param && Integer.valueOf(1).equals(((Param)this.numberOfRows).getValue());
    }

    final boolean offsetZero() {
        return this.offset == null;
    }

    final Field<Integer> getLowerRownum() {
        return this.offsetOrZero;
    }

    final Field<Integer> getUpperRownum() {
        return this.offsetOrZero.add(this.numberOfRowsOrMax);
    }

    final boolean isApplicable() {
        return this.offset != null || this.numberOfRows != null;
    }

    final boolean rendersParams() {
        return this.rendersParams;
    }

    final void setOffset(int offset) {
        if (offset != 0) {
            this.offset = DSL.val((Object)offset, SQLDataType.INTEGER);
            this.offsetOrZero = this.offset;
            this.offsetPlusOne = DSL.val((Object)(offset + 1), SQLDataType.INTEGER);
        }
    }

    final void setOffset(Param<Integer> offset) {
        this.offset = offset;
        this.offsetOrZero = offset;
        this.rendersParams = this.rendersParams |= offset.isInline();
    }

    final void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = DSL.val((Object)numberOfRows, SQLDataType.INTEGER);
        this.numberOfRowsOrMax = this.numberOfRows;
    }

    final void setNumberOfRows(Param<Integer> numberOfRows) {
        this.numberOfRows = numberOfRows;
        this.numberOfRowsOrMax = numberOfRows;
        this.rendersParams |= numberOfRows.isInline();
    }

    final void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    final boolean withTies() {
        return this.withTies;
    }
}

