/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocolPB.OMAdminProtocolClientSideImpl;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="compact", description={"CLI to compact a column family in the om.db. The compaction happens asynchronously. Requires admin privileges."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CompactOMDB
extends RepairTool {
    @CommandLine.Option(names={"--column-family", "--column_family", "--cf"}, required=true, description={"Column family name"})
    private String columnFamilyName;
    @CommandLine.Option(names={"--service-id", "--om-service-id"}, description={"Ozone Manager Service ID"}, required=false)
    private String omServiceId;
    @CommandLine.Option(names={"--node-id"}, description={"NodeID of the OM for which db needs to be compacted."}, required=false)
    private String nodeId;

    @Override
    public void execute() throws Exception {
        OzoneConfiguration conf = this.getOzoneConf();
        OMNodeDetails omNodeDetails = OMNodeDetails.getOMNodeDetailsFromConf((OzoneConfiguration)conf, (String)this.omServiceId, (String)this.nodeId);
        if (!this.isDryRun()) {
            try (OMAdminProtocolClientSideImpl omAdminProtocolClient = OMAdminProtocolClientSideImpl.createProxyForSingleOM((OzoneConfiguration)conf, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (OMNodeDetails)omNodeDetails);){
                omAdminProtocolClient.compactOMDB(this.columnFamilyName);
                this.info("Compaction request issued for om.db of om node: %s, column-family: %s.", this.nodeId, this.columnFamilyName);
                this.info("Please check role logs of %s for completion status.", this.nodeId);
            }
            catch (IOException ex) {
                this.error("Couldn't compact column %s. \nException: %s", this.columnFamilyName, ex);
            }
        }
    }
}

