/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.ratis.parse;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.ha.SCMRatisRequest;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.debug.ratis.parse.BaseLogParser;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import picocli.CommandLine;

@CommandLine.Command(name="parse", description={"Shell for printing Ratis Log in understandable text"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class RatisLogParser
extends BaseLogParser
implements Callable<Void> {
    @CommandLine.Option(names={"--role"}, defaultValue="generic", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, description={"Component role for parsing. Values: om, scm, datanode"})
    private String role;
    private static final RaftGroupId DUMMY_PIPELINE_ID = RaftGroupId.valueOf((ByteString)ByteString.copyFromUtf8((String)"ADummyRatisGroup"));

    public static String smToContainerLogString(RaftProtos.StateMachineLogEntryProto logEntryProto) {
        return ContainerStateMachine.smProtoToString((RaftGroupId)DUMMY_PIPELINE_ID, null, (RaftProtos.StateMachineLogEntryProto)logEntryProto);
    }

    @Override
    public Void call() throws Exception {
        switch (this.role.toLowerCase()) {
            case "om": {
                System.out.println("Dumping OM Ratis Log");
                this.parseRatisLogs(OMRatisHelper::smProtoToString);
                break;
            }
            case "scm": {
                System.out.println("Dumping SCM Ratis Log");
                this.parseRatisLogs(SCMRatisRequest::smProtoToString);
                break;
            }
            case "datanode": {
                System.out.println("Dumping Datanode Ratis Log");
                System.out.println("Using Dummy PipelineID:" + DUMMY_PIPELINE_ID + "\n\n");
                this.parseRatisLogs(RatisLogParser::smToContainerLogString);
                break;
            }
            default: {
                System.out.println("Dumping Generic Ratis Log");
                this.parseRatisLogs(null);
            }
        }
        return null;
    }
}

