/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.om;

import com.google.common.graph.MutableGraph;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.debug.om.OMDebug;
import org.apache.ozone.compaction.log.CompactionLogEntry;
import org.apache.ozone.graph.PrintableGraph;
import org.apache.ozone.rocksdiff.CompactionDag;
import org.apache.ozone.rocksdiff.CompactionNode;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import picocli.CommandLine;

@CommandLine.Command(name="generate-compaction-dag", aliases={"gcd"}, description={"Create an image of the current compaction log DAG. This command is an offline command. i.e., it can run on any instance of om.db and does not require OM to be up."})
public class CompactionLogDagPrinter
extends AbstractSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMDebug parent;
    @CommandLine.Option(names={"-o", "--output-file"}, required=true, description={"Path to location at which image will be downloaded. Should include the image file name with \".png\" extension."})
    private String imageLocation;

    @Override
    public Void call() throws Exception {
        try {
            ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
            List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.parent.getDbPath());
            ManagedRocksDB activeRocksDB = ManagedRocksDB.openReadOnly((String)this.parent.getDbPath(), cfDescList, cfHandleList);
            ColumnFamilyHandle compactionLogTableCFHandle = RocksDBUtils.getColumnFamilyHandle("compactionLogTable", cfHandleList);
            CompactionDag compactionDag = new CompactionDag();
            this.loadCompactionDagFromDB(activeRocksDB, compactionLogTableCFHandle, compactionDag);
            this.pngPrintMutableGraph(compactionDag, this.imageLocation);
            this.out().println("Graph was generated at '" + this.imageLocation + "'.");
        }
        catch (RocksDBException ex) {
            this.err().println("Failed to open RocksDB: " + (Object)((Object)ex));
            throw ex;
        }
        return null;
    }

    private void loadCompactionDagFromDB(ManagedRocksDB activeRocksDB, ColumnFamilyHandle compactionLogTableCFHandle, CompactionDag compactionDag) {
        try (ManagedRocksIterator managedRocksIterator = new ManagedRocksIterator(((RocksDB)activeRocksDB.get()).newIterator(compactionLogTableCFHandle));){
            ((RocksIterator)managedRocksIterator.get()).seekToFirst();
            while (((RocksIterator)managedRocksIterator.get()).isValid()) {
                byte[] value = ((RocksIterator)managedRocksIterator.get()).value();
                CompactionLogEntry compactionLogEntry = CompactionLogEntry.getFromProtobuf((HddsProtos.CompactionLogEntryProto)HddsProtos.CompactionLogEntryProto.parseFrom((byte[])value));
                compactionDag.populateCompactionDAG(compactionLogEntry.getInputFileInfoList(), compactionLogEntry.getOutputFileInfoList(), compactionLogEntry.getDbSequenceNumber());
                ((RocksIterator)managedRocksIterator.get()).next();
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public void pngPrintMutableGraph(CompactionDag helper, String filePath) throws IOException {
        Objects.requireNonNull(filePath, "Image file path is required.");
        PrintableGraph graph = new PrintableGraph((MutableGraph<CompactionNode>)helper.getBackwardCompactionDAG(), PrintableGraph.GraphType.FILE_NAME);
        graph.generateImage(filePath);
    }
}

