/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.logs.container;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.ozone.debug.logs.container.ContainerInfoCommand;
import org.apache.hadoop.ozone.debug.logs.container.ContainerLogParser;
import org.apache.hadoop.ozone.debug.logs.container.DuplicateOpenContainersCommand;
import org.apache.hadoop.ozone.debug.logs.container.ListContainers;
import picocli.CommandLine;

@CommandLine.Command(name="container", subcommands={ContainerInfoCommand.class, ContainerLogParser.class, DuplicateOpenContainersCommand.class, ListContainers.class}, description={"Tool to parse and store container logs from datanodes into a temporary SQLite database. Supports querying state transitions of container replicas using various subcommands."})
public class ContainerLogController
extends AbstractSubcommand {
    @CommandLine.Option(names={"--db"}, scope=CommandLine.ScopeType.INHERIT, description={"Path to the SQLite database file where the parsed information from logs is stored."})
    private String dbPath;

    public String getDbPath() {
        return this.dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path resolveDbPath() {
        Path resolvedPath;
        if (this.dbPath == null) {
            resolvedPath = Paths.get(System.getProperty("user.dir"), "container_datanode.db");
            if (!Files.exists(resolvedPath, new LinkOption[0]) || !Files.isRegularFile(resolvedPath, new LinkOption[0])) throw new IllegalArgumentException("No database path provided and default file 'container_datanode.db' not found in current directory. Please provide a valid database path");
            this.out().println("Using default database file found in current directory: " + resolvedPath);
            return resolvedPath;
        } else {
            resolvedPath = Paths.get(this.dbPath, new String[0]);
            Path parentDir = resolvedPath.getParent();
            if (parentDir == null || Files.exists(parentDir, new LinkOption[0])) return resolvedPath;
            throw new IllegalArgumentException("The parent directory of the provided database path does not exist: " + parentDir);
        }
    }
}

