/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.logs.container;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.ozone.debug.logs.container.ContainerLogController;
import org.apache.hadoop.ozone.debug.logs.container.utils.ContainerDatanodeDatabase;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Provides complete state transition history of each replica for a single container along with analysis over the container"})
public class ContainerInfoCommand
extends AbstractSubcommand
implements Callable<Void> {
    @CommandLine.Parameters(index="0", description={"Container ID"})
    private Long containerId;
    @CommandLine.ParentCommand
    private ContainerLogController parent;

    @Override
    public Void call() throws Exception {
        if (this.containerId < 0L) {
            this.err().println("Invalid container ID: " + this.containerId);
            return null;
        }
        Path dbPath = this.parent.resolveDbPath();
        ContainerDatanodeDatabase cdd = new ContainerDatanodeDatabase(dbPath.toString());
        cdd.showContainerDetails(this.containerId);
        return null;
    }
}

