/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.MultiException;
import org.apache.karaf.util.jaas.JaasHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;

@Command(scope="bundle", name="install", description="Installs one or more bundles.")
@Service
public class Install
implements Action {
    @Argument(index=0, name="urls", description="Bundle URLs separated by whitespaces", required=true, multiValued=true)
    List<URI> urls;
    @Option(name="-s", aliases={"--start"}, description="Starts the bundles after installation", required=false, multiValued=false)
    boolean start;
    @Option(name="-l", aliases={"--start-level"}, description="Sets the start level of the bundles", required=false, multiValued=false)
    Integer level;
    @Option(name="--force", aliases={"-f"}, description="Forces the command to execute", required=false, multiValued=false)
    boolean force;
    @Option(name="--r3-bundles", description="Allow OSGi R3 bundles")
    boolean allowR3;
    @Reference
    Session session;
    @Reference
    BundleService bundleService;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        if (this.level != null) {
            int sbsl = this.bundleService.getSystemBundleThreshold();
            if (this.level < sbsl && !JaasHelper.currentUserHasRole("systembundles")) {
                throw new IllegalArgumentException("Insufficient privileges");
            }
        }
        boolean r3warned = false;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (URI url : this.urls) {
            try {
                Bundle bundle = this.bundleContext.installBundle(url.toString(), null);
                String manifestVersion = (String)bundle.getHeaders().get("Bundle-ManifestVersion");
                if (!"2".equals(manifestVersion)) {
                    if (this.allowR3) {
                        if (!r3warned) {
                            System.err.println("WARNING: use of OSGi r3 bundles is discouraged");
                            r3warned = true;
                        }
                    } else {
                        String error = manifestVersion == null ? "The provided URL is not a valid OSGi bundle. Consider using Karaf wrap feature, e.g. `install wrap:mvn:groupId/artifactId/version`. See more here: https://karaf.apache.org/manual/latest/#_wrap_deployer" : "OSGi R3 bundle not supported";
                        bundle.uninstall();
                        throw new BundleException(error);
                    }
                }
                bundles.add(bundle);
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to install bundle " + String.valueOf(url) + ": " + e.toString(), e));
            }
        }
        if (this.level != null) {
            for (Bundle bundle : bundles) {
                try {
                    ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(this.level.intValue());
                }
                catch (Exception e) {
                    exceptions.add(new Exception("Unable to set bundle start level " + bundle.getLocation() + ": " + e.toString(), e));
                }
            }
        }
        if (this.start) {
            for (Bundle bundle : bundles) {
                try {
                    bundle.start();
                }
                catch (Exception e) {
                    exceptions.add(new Exception("Unable to start bundle " + bundle.getLocation() + ": " + e.toString(), e));
                }
            }
        }
        if (bundles.size() == 1) {
            System.out.println("Bundle ID: " + ((Bundle)bundles.get(0)).getBundleId());
        } else {
            String msg = bundles.stream().map(b -> Long.toString(b.getBundleId())).collect(Collectors.joining(", ", "Bundle IDs: ", ""));
            System.out.println(msg);
        }
        MultiException.throwIf((String)"Error installing bundles", exceptions);
        return null;
    }
}

