/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVTempResult;
import org.h2.result.LocalResult;
import org.h2.result.ResultExternal;
import org.h2.result.SortOrder;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueRow;

public class LocalResultImpl
implements LocalResult {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ArrayList<Value[]> rows;
    private SortOrder sort;
    private TreeMap<Value, Value[]> distinctRows;
    private Value[] currentRow;
    private int offset;
    private int limit = -1;
    private boolean fetchPercent;
    private SortOrder withTiesSortOrder;
    private boolean limitsWereApplied;
    private ResultExternal external;
    private boolean distinct;
    private int[] distinctIndexes;
    private boolean closed;
    private boolean containsLobs;
    private Boolean containsNull;

    public LocalResultImpl() {
    }

    public LocalResultImpl(Session session, Expression[] expressionArray, int n) {
        Database database;
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : ((database = session.getDatabase()).isPersistent() && !database.isReadOnly() ? session.getDatabase().getMaxMemoryRows() : Integer.MAX_VALUE);
        this.rows = Utils.newSmallArrayList();
        this.visibleColumnCount = n;
        this.rowId = -1;
        this.expressions = expressionArray;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    @Override
    public LocalResultImpl createShallowCopy(SessionInterface sessionInterface) {
        if (this.external == null && (this.rows == null || this.rows.size() < this.rowCount)) {
            return null;
        }
        if (this.containsLobs) {
            return null;
        }
        ResultExternal resultExternal = null;
        if (this.external != null && (resultExternal = this.external.createShallowCopy()) == null) {
            return null;
        }
        LocalResultImpl localResultImpl = new LocalResultImpl();
        localResultImpl.maxMemoryRows = this.maxMemoryRows;
        localResultImpl.session = (Session)sessionInterface;
        localResultImpl.visibleColumnCount = this.visibleColumnCount;
        localResultImpl.expressions = this.expressions;
        localResultImpl.rowId = -1;
        localResultImpl.rowCount = this.rowCount;
        localResultImpl.rows = this.rows;
        localResultImpl.sort = this.sort;
        localResultImpl.distinctRows = this.distinctRows;
        localResultImpl.distinct = this.distinct;
        localResultImpl.distinctIndexes = this.distinctIndexes;
        localResultImpl.currentRow = null;
        localResultImpl.offset = 0;
        localResultImpl.limit = -1;
        localResultImpl.external = resultExternal;
        localResultImpl.containsNull = this.containsNull;
        return localResultImpl;
    }

    @Override
    public void setSortOrder(SortOrder sortOrder) {
        this.sort = sortOrder;
    }

    @Override
    public void setDistinct() {
        assert (this.distinctIndexes == null);
        this.distinct = true;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    @Override
    public void setDistinct(int[] nArray) {
        assert (!this.distinct);
        this.distinctIndexes = nArray;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    private boolean isAnyDistinct() {
        return this.distinct || this.distinctIndexes != null;
    }

    @Override
    public void removeDistinct(Value[] valueArray) {
        if (!this.distinct) {
            DbException.throwInternalError();
        }
        assert (valueArray.length == this.visibleColumnCount);
        if (this.distinctRows != null) {
            ValueRow valueRow = ValueRow.get(valueArray);
            this.distinctRows.remove(valueRow);
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.external.removeRow(valueArray);
        }
    }

    @Override
    public boolean containsDistinct(Value[] valueArray) {
        Object object;
        assert (valueArray.length == this.visibleColumnCount);
        if (this.external != null) {
            return this.external.contains(valueArray);
        }
        if (this.distinctRows == null) {
            this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
            object = this.rows.iterator();
            while (object.hasNext()) {
                Value[] valueArray2 = (Value[])object.next();
                ValueRow valueRow = this.getDistinctRow(valueArray2);
                this.distinctRows.put(valueRow, valueRow.getList());
            }
        }
        return this.distinctRows.get(object = ValueRow.get(valueArray)) != null;
    }

    @Override
    public boolean containsNull() {
        Boolean bl = this.containsNull;
        if (bl == null) {
            bl = false;
            this.reset();
            block0: while (this.next()) {
                Value[] valueArray = this.currentRow;
                for (int i = 0; i < this.visibleColumnCount; ++i) {
                    if (!valueArray[i].containsNull()) continue;
                    bl = true;
                    break block0;
                }
            }
            this.reset();
            this.containsNull = bl;
        }
        return bl;
    }

    @Override
    public void reset() {
        this.rowId = -1;
        this.currentRow = null;
        if (this.external != null) {
            this.external.reset();
        }
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (!this.closed && this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.external != null ? this.external.next() : this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rowCount;
    }

    private void cloneLobs(Value[] valueArray) {
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray[i];
            Value value2 = value.copyToResult();
            if (value2 == value) continue;
            this.containsLobs = true;
            this.session.addTemporaryLob(value2);
            valueArray[i] = value2;
        }
    }

    private ValueRow getDistinctRow(Value[] valueArray) {
        if (this.distinctIndexes != null) {
            int n = this.distinctIndexes.length;
            Value[] valueArray2 = new Value[n];
            for (int i = 0; i < n; ++i) {
                valueArray2[i] = valueArray[this.distinctIndexes[i]];
            }
            valueArray = valueArray2;
        } else if (valueArray.length > this.visibleColumnCount) {
            valueArray = Arrays.copyOf(valueArray, this.visibleColumnCount);
        }
        return ValueRow.get(valueArray);
    }

    private void createExternalResult() {
        this.external = MVTempResult.of(this.session.getDatabase(), this.expressions, this.distinct, this.distinctIndexes, this.visibleColumnCount, this.sort);
    }

    @Override
    public void addRow(Value[] valueArray) {
        this.cloneLobs(valueArray);
        if (this.isAnyDistinct()) {
            if (this.distinctRows != null) {
                ValueRow valueRow = this.getDistinctRow(valueArray);
                Value[] valueArray2 = this.distinctRows.get(valueRow);
                if (valueArray2 == null || this.sort != null && this.sort.compare(valueArray2, valueArray) > 0) {
                    this.distinctRows.put(valueRow, valueArray);
                }
                this.rowCount = this.distinctRows.size();
                if (this.rowCount > this.maxMemoryRows) {
                    this.createExternalResult();
                    this.rowCount = this.external.addRows(this.distinctRows.values());
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.external.addRow(valueArray);
            }
        } else {
            this.rows.add(valueArray);
            ++this.rowCount;
            if (this.rows.size() > this.maxMemoryRows) {
                this.addRowsToDisk();
            }
        }
    }

    private void addRowsToDisk() {
        if (this.external == null) {
            this.createExternalResult();
        }
        this.rowCount = this.external.addRows(this.rows);
        this.rows.clear();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    @Override
    public void done() {
        if (this.external != null) {
            this.addRowsToDisk();
        } else {
            if (this.isAnyDistinct()) {
                this.rows = new ArrayList<Value[]>(this.distinctRows.values());
            }
            if (this.sort != null && this.limit != 0 && !this.limitsWereApplied) {
                boolean bl;
                boolean bl2 = bl = this.limit > 0 && this.withTiesSortOrder == null;
                if (this.offset > 0 || bl) {
                    this.sort.sort(this.rows, this.offset, bl ? this.limit : this.rows.size());
                } else {
                    this.sort.sort(this.rows);
                }
            }
        }
        this.applyOffsetAndLimit();
        this.reset();
    }

    private void applyOffsetAndLimit() {
        int n;
        boolean bl;
        if (this.limitsWereApplied) {
            return;
        }
        int n2 = Math.max(this.offset, 0);
        int n3 = this.limit;
        if (n2 == 0 && n3 < 0 && !this.fetchPercent || this.rowCount == 0) {
            return;
        }
        if (this.fetchPercent) {
            if (n3 < 0 || n3 > 100) {
                throw DbException.getInvalidValueException("FETCH PERCENT", n3);
            }
            n3 = (int)(((long)n3 * (long)this.rowCount + 99L) / 100L);
        }
        boolean bl2 = bl = n2 >= this.rowCount || n3 == 0;
        if (!bl) {
            n = this.rowCount - n2;
            int n4 = n3 = n3 < 0 ? n : Math.min(n, n3);
            if (n2 == 0 && n <= n3) {
                return;
            }
        } else {
            n3 = 0;
        }
        this.distinctRows = null;
        this.rowCount = n3;
        if (this.external == null) {
            if (bl) {
                this.rows.clear();
                return;
            }
            n = n2 + n3;
            if (this.withTiesSortOrder != null) {
                Value[] valueArray = this.rows.get(n - 1);
                while (n < this.rows.size() && this.withTiesSortOrder.compare(valueArray, this.rows.get(n)) == 0) {
                    ++n;
                    ++this.rowCount;
                }
            }
            if (n2 != 0 || n != this.rows.size()) {
                this.rows = new ArrayList<Value[]>(this.rows.subList(n2, n));
            }
        } else {
            if (bl) {
                this.external.close();
                this.external = null;
                return;
            }
            this.trimExternal(n2, n3);
        }
    }

    private void trimExternal(int n, int n2) {
        ResultExternal resultExternal = this.external;
        this.external = null;
        resultExternal.reset();
        while (--n >= 0) {
            resultExternal.next();
        }
        Value[] valueArray = null;
        while (--n2 >= 0) {
            valueArray = resultExternal.next();
            this.rows.add(valueArray);
            if (this.rows.size() <= this.maxMemoryRows) continue;
            this.addRowsToDisk();
        }
        if (this.withTiesSortOrder != null && valueArray != null) {
            Value[] valueArray2 = valueArray;
            while ((valueArray = resultExternal.next()) != null && this.withTiesSortOrder.compare(valueArray2, valueArray) == 0) {
                this.rows.add(valueArray);
                ++this.rowCount;
                if (this.rows.size() <= this.maxMemoryRows) continue;
                this.addRowsToDisk();
            }
        }
        if (this.external != null) {
            this.addRowsToDisk();
        }
        resultExternal.close();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void limitsWereApplied() {
        this.limitsWereApplied = true;
    }

    @Override
    public boolean hasNext() {
        return !this.closed && this.rowId < this.rowCount - 1;
    }

    @Override
    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public void setFetchPercent(boolean bl) {
        this.fetchPercent = bl;
    }

    @Override
    public void setWithTies(SortOrder sortOrder) {
        assert (this.sort == null || this.sort == sortOrder);
        this.withTiesSortOrder = sortOrder;
    }

    @Override
    public boolean needToClose() {
        return this.external != null;
    }

    @Override
    public void close() {
        if (this.external != null) {
            this.external.close();
            this.external = null;
            this.closed = true;
        }
    }

    @Override
    public String getAlias(int n) {
        return this.expressions[n].getAlias();
    }

    @Override
    public String getTableName(int n) {
        return this.expressions[n].getTableName();
    }

    @Override
    public String getSchemaName(int n) {
        return this.expressions[n].getSchemaName();
    }

    @Override
    public String getColumnName(int n) {
        return this.expressions[n].getColumnName();
    }

    @Override
    public TypeInfo getColumnType(int n) {
        return this.expressions[n].getType();
    }

    @Override
    public int getNullable(int n) {
        return this.expressions[n].getNullable();
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return this.expressions[n].isAutoIncrement();
    }

    @Override
    public void setOffset(int n) {
        this.offset = n;
    }

    public String toString() {
        return super.toString() + " columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public void setFetchSize(int n) {
    }
}

