/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpFilterChain;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.support.ExpectSupport;
import org.apache.hc.core5.http.support.Expectation;

@Contract(threading=ThreadingBehavior.STATELESS)
public class HttpServerExpectationFilter
implements HttpFilterHandler {
    protected boolean verify(ClassicHttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected HttpEntity generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        Expectation expectation = ExpectSupport.parse(request, request.getEntity());
        if (expectation == Expectation.CONTINUE) {
            boolean verified = this.verify(request, context);
            if (!verified) {
                BasicClassicHttpResponse expectationFailed = new BasicClassicHttpResponse(417);
                HttpEntity responseContent = this.generateResponseContent(expectationFailed);
                expectationFailed.setEntity(responseContent);
                responseTrigger.submitResponse(expectationFailed);
                return;
            }
            responseTrigger.sendInformation(new BasicClassicHttpResponse(100));
        } else if (expectation == Expectation.UNKNOWN) {
            BasicClassicHttpResponse expectationFailed = new BasicClassicHttpResponse(417);
            HttpEntity responseContent = this.generateResponseContent(expectationFailed);
            expectationFailed.setEntity(responseContent);
            responseTrigger.submitResponse(expectationFailed);
            return;
        }
        chain.proceed(request, responseTrigger, context);
    }
}

