/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.CountAggregate;
import org.apache.iceberg.expressions.Expression;

public class CountStar<T>
extends CountAggregate<T> {
    protected CountStar(BoundTerm<T> term) {
        super(Expression.Operation.COUNT_STAR, term);
    }

    @Override
    protected Long countFor(StructLike row) {
        return 1L;
    }

    @Override
    protected boolean hasValue(DataFile file) {
        return file.recordCount() >= 0L;
    }

    @Override
    protected Long countFor(DataFile file) {
        long count = file.recordCount();
        if (count < 0L) {
            return null;
        }
        return count;
    }
}

