/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.ops;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.authentication.SupportsKerberos;
import org.apache.gravitino.iceberg.common.ops.IcebergCatalogWrapper;
import org.apache.iceberg.catalog.Catalog;

public class KerberosAwareIcebergCatalogProxy
implements MethodInterceptor {
    private final IcebergCatalogWrapper target;
    private final Catalog catalog;

    public KerberosAwareIcebergCatalogProxy(IcebergCatalogWrapper target) {
        this.target = target;
        this.catalog = target.getCatalog();
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        if (this.catalog instanceof SupportsKerberos) {
            SupportsKerberos kerberosCatalog = (SupportsKerberos)this.catalog;
            return kerberosCatalog.doKerberosOperations(() -> methodProxy.invoke((Object)this.target, objects));
        }
        return method.invoke((Object)this.target, objects);
    }

    public IcebergCatalogWrapper getProxy(IcebergConfig config) {
        Enhancer e = new Enhancer();
        e.setClassLoader(this.target.getClass().getClassLoader());
        e.setSuperclass(this.target.getClass());
        e.setCallback((Callback)this);
        Class[] argClass = new Class[]{IcebergConfig.class};
        return (IcebergCatalogWrapper)e.create(argClass, new Object[]{config});
    }

    public IcebergCatalogWrapper getProxy(String catalogName, IcebergConfig config) {
        Enhancer e = new Enhancer();
        e.setClassLoader(this.target.getClass().getClassLoader());
        e.setSuperclass(this.target.getClass());
        e.setCallback((Callback)this);
        Class[] argClass = new Class[]{String.class, IcebergConfig.class};
        return (IcebergCatalogWrapper)e.create(argClass, new Object[]{catalogName, config});
    }
}

