#import <Foundation/Foundation.h>

#import "IMoney.h"

@class Money;

@interface MoneyBag : NSObject <IMoney> {
@private
    NSMutableArray *fMonies;
}

- (id)initWithMoneyArray:(NSArray *)array;
- (id)initWithMoney:(Money *)money1 money:(Money *)money2;
- (id)initWithMoney:(Money *)money bag:(MoneyBag *)bag;
- (id)initWithMoneyBag:(MoneyBag *)bag1 bag:(MoneyBag *)bag2;

- (id<IMoney>)add:(id<IMoney>)money;
- (id<IMoney>)addMoney:(Money *)money;
- (id<IMoney>)addMoneyBag:(MoneyBag *)bag;

- (BOOL)isEqual:(id)anObject;

- (BOOL)isZero;

- (id<IMoney>)multiply:(int)factor;

- (id<IMoney>)negate;

- (id<IMoney>)subtract:(id<IMoney>)money;

- (NSString *)description;

@end
