/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.navigation;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import org.j3d.renderer.java3d.navigation.FrameUpdateListener;
import org.j3d.renderer.java3d.navigation.J3DViewpointData;
import org.j3d.renderer.java3d.navigation.ViewpointTransition;
import org.j3d.ui.navigation.ViewpointData;
import org.j3d.ui.navigation.ViewpointSelectionListener;
import org.j3d.ui.navigation.ViewpointToolbar;

public class ViewpointManager
implements ViewpointSelectionListener {
    private static final int DEFAULT_TRANSITION_TIME = 2000;
    private ViewpointToolbar toolbar;
    private ViewpointTransition transistor;
    private int transitionTime;
    private View view;
    private TransformGroup viewTg;
    private Transform3D destinationTx;

    public ViewpointManager() {
        this(2000);
    }

    public ViewpointManager(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative transition time");
        }
        this.transitionTime = n;
        this.transistor = new ViewpointTransition();
        this.destinationTx = new Transform3D();
    }

    public void setToolbar(ViewpointToolbar viewpointToolbar) {
        if (this.toolbar != null) {
            this.toolbar.setViewpointSelectionListener(null);
        }
        this.toolbar = viewpointToolbar;
        if (this.toolbar != null) {
            this.toolbar.setEnabled(this.view != null);
            this.toolbar.setViewpointSelectionListener(this);
        }
    }

    public void setTransitionTime(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative transition time");
        }
        this.transitionTime = n;
    }

    public void setViewInfo(View view, TransformGroup transformGroup) {
        if (view == null || transformGroup == null || view == null && transformGroup == null) {
            throw new IllegalArgumentException("View or TG is null when the other isn't");
        }
        if (this.toolbar != null) {
            this.toolbar.setEnabled(view != null);
        }
        this.view = view;
        this.viewTg = transformGroup;
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.transistor.setFrameUpdateListener(frameUpdateListener);
    }

    public void viewpointSelected(ViewpointData viewpointData) {
        if (this.view == null) {
            return;
        }
        if (!(viewpointData instanceof J3DViewpointData)) {
            throw new IllegalArgumentException("Not an instance of J3DViewpointData");
        }
        ((J3DViewpointData)viewpointData).viewTg.getTransform(this.destinationTx);
        this.transistor.transitionTo(this.view, this.viewTg, this.destinationTx, this.transitionTime);
    }
}

