Guidelines for Contributing
===========================

Welcome to the vibe.d repository and thank you for your interest in contributing to its development!

When contributing pull requests, the following points should ideally apply:

 - Each pull request should contain only one isolated functional change
 - The code adheres to the [style guide](http://vibed.org/style-guide)
 - For the occasional more complex pull request each change should be separated into its own commit
 - Try not to mix whitespace or style changes with functional changes in the same commit
 - The pull request must pass the test suite (run `dub test` to test locally)

Exceptions to these rules are accepted all the time, but please try to follow them as closely as possible, because otherwise it often considerably increases the total amount of work and communication overhead.
