/*
 * =========================== 
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _VDKB_EVENT_CONTAINER_H
#define _VDKB_EVENT_CONTAINER_H

#include <vdk/evlisthandle.h>
#include <vdk/siglisthandle.h>
#include <vdk/evhandle.h>
#include <vdk/dlist.h>
#include <vdk/canvas.h>
#include <vdk/forms.h>
#include <vdk/widcontain.h>
#include <vdk/canvas.h>
#include <vdkb2/vdkb_object.h>
typedef VDKList<VDKObject> EventBoxList;
typedef VDKListIterator<VDKObject> EventBoxListIterator;


/*
 */
class VDKBCanvas: public VDKCanvas, public VDKBObject
{
  
 public:
  static int Counter;
  VDKBCanvas(char* name,VDKForm* owner, int w, int h);
  virtual ~VDKBCanvas() {}
  void Mark();
  void DrawUnfilledRect(int x, int y, int w, int h);
  bool OnExpose(VDKObject* sender, GdkEvent* event);
  virtual int isA() { return vdkbcanvas_class; }
  virtual int Type() { return vdkbcanvas_class; }
  virtual char* VDKName() { return "VDKCanvas"; }
  DECLARE_EVENT_LIST(VDKBCanvas);
};

/*
 */
class VDKBObjectInspector;
class VDKBContainerPopMenu;
class VDKBEventContainer: public VDKObjectContainer, public VDKBObject
{
 protected:

  GtkWidget* container;
  VDKBEventContainer* outerbox;
  int slot, mode;
  VDKMenuItem* selectparent;
  bool BinCheck(VDKObject* wid);
  VDKSpinButton* borderspin;
  VDKBObjectInspector* inspector; // object inspector
 public:
  VDKBContainerPopMenu *popmenu;
  static int Counter;
  VDKBCanvas* canvas;
  // don't be confused, really boxlist can contain any vdkobject :-)
  EventBoxList boxlist;
  VDKBEventContainer(char* name, VDKForm* owner);

  virtual ~VDKBEventContainer() {}

  virtual void Add(VDKObject* obj, int justify = l_justify,
		   int expand = TRUE, int fill = TRUE , int padding = 0);
  // last arg forces previous args to be used
  virtual void AddWidget(VDKObject* obj, int justify = l_justify,
			 int expand = TRUE, int fill = TRUE , 
			 int padding = 0, bool forceArgs = false)
    {}

  GtkWidget* Container() { return container; }
  // common actions
  bool DelBox(VDKObject*);
  bool OnButtonPressed(VDKObject* sender, GdkEvent* event);
  bool OnExpose(VDKObject* sender, GdkEvent* event);
  bool SelectParentContainer(VDKObject*);
  bool PasteWidget(VDKObject*);
  virtual void ClearMark();
  virtual void Mark();
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  virtual void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  bool OnBorderWidth(VDKObject*);
  // access
  VDKBEventContainer* Outerbox(VDKBEventContainer* b = NULL);
  int Mode() { return mode; }
  VDKBCanvas* Canvas() { return canvas; }
  virtual int Type() { return vdkbclass_evcontainer; }
  virtual int isA() { return vdkbclass_evcontainer; }
  virtual char* VDKName() { return "VDKObjectContainer"; }
  DECLARE_SIGNAL_LIST(VDKBEventContainer);  
  DECLARE_EVENT_LIST(VDKBEventContainer);  
};

#endif
