# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185946;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"772932", "Beineu",
"772353", "Novaya\ Shulba",
"7494", "Kostroma",
"7388", "Republic\ of\ Altai",
"77272", "Almaty",
"772538", "Turara\ Ryskulova",
"771131", "Darinskoye",
"77152", "Petropavlovsk",
"7395", "Irkutsk",
"7424", "Sakhalin\ Region",
"771642", "Egendykol",
"772344", "Akzhar",
"772778", "Chundzha",
"772251", "Kurchatov",
"771630", "Burabay",
"772833", "Usharal",
"7821", "Komi\ Republic",
"771139", "Taskala",
"772337", "Serebryansk",
"7867", "Republic\ of\ North\ Ossetia",
"772149", "Osakarovka",
"77135", "Aktobe\ Region",
"771347", "Aitekebisky\ District",
"772632", "Merke",
"771334", "Emba",
"772640", "Moiynkumsky\ District",
"771843", "Maisky\ District",
"7492", "Vladimir",
"771640", "Balkashino",
"771632", "Zerenda",
"7851", "Astrakhan",
"772334", "Tavricheskoye",
"772843", "Lepsy",
"772347", "Kalbatau",
"7865", "Stavropol\ territory",
"771149", "Zelenovsky\ District",
"771337", "Alga",
"77187", "Ekibastuz",
"772642", "Moiynkum",
"7844", "Volgograd",
"771459", "Kostanai\ Region",
"7811", "Pskov",
"771833", "Terenkol",
"7842", "Ulyanovsk",
"771451", "Sarykol",
"772548", "Shayan",
"772131", "Abai",
"7301", "Republic\ of\ Buryatia",
"77252", "Shymkent",
"771141", "Zhangala",
"771538", "Beskol",
"7712303", "Tengizs",
"772542", "Asykata",
"772530", "Temirlanovka",
"77292", "Aktau",
"771839", "Akku",
"771453", "Auliekol",
"7413", "Magadan",
"7866", "Kabardino\-Balkarian\ Republic",
"7475", "Tambov",
"771143", "Akzhaik",
"771532", "Smirnovo",
"771237", "Kulsary",
"771540", "Kishkenekol",
"771437", "Kamysty",
"771034", "Zhezdy",
"771444", "Uzunkol",
"7843", "Republic\ of\ Tatarstan",
"772841", "Kapal",
"7381", "Omsk",
"7869", "Sevastopol",
"772770", "Uzynagash",
"771638", "Akkol",
"77262", "Taraz",
"771831", "Zhelezinka",
"77245", "Kyzylorda\ Region",
"771447", "Karabalyksky\ District",
"772154", "Botakara",
"771434", "Denisovka",
"772831", "Zharkent",
"77162", "Kokshetau\/Krasni\ Yar",
"771037", "Aktogai",
"772772", "Kapchagai",
"77213", "Aktau\/Temirtau",
"771648", "Derzhavinsk",
"771841", "Aktogai",
"736", "Simferopol",
"772638", "Tole\ bi",
"772437", "Zhosaly",
"772237", "Ayagoz",
"772540", "Arys",
"772532", "Abai",
"772351", "Borodulikha",
"772938", "Fort\ Shevchenko",
"7423", "Primorie\ territory",
"77279", "Almaty",
"772839", "Sarkand",
"771234", "Indernborski",
"7818", "Arkhangelsk",
"77125", "Atyrau\ Region",
"771542", "Kishkenekol",
"771133", "Aksai",
"7813", "Leningrad\ region",
"771144", "Kaztalovka",
"771635", "Zhaksy",
"7384", "Kemerovo",
"772339", "Kurchum",
"7498", "Moscow",
"7346", "Surgut",
"771137", "Chingirlau",
"771454", "Karamendy",
"771349", "Shalkarsky\ District",
"772147", "Egindybulak",
"7485", "Yaroslavl",
"77145834", "Krasnogorsk",
"772433", "Aralsk",
"771341", "Khobda",
"771636", "Shuchinsk",
"771443", "Borovskoi",
"772331", "Glubokoye",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"771033", "Agadyr",
"7382", "Tomsk",
"772257", "Shulbinsk",
"77224", "Barshatas",
"772935", "Zhetybai",
"771331", "Martuk",
"771646", "Makinsk",
"7835", "Chuvashi\ Republic",
"771433", "Lisakovsk",
"772341", "Ulken\ Naryn",
"7848", "Tolyatti",
"772636", "Kordai",
"771043", "Zhairem",
"772752", "Otegen\ Batyra",
"772153", "Topar",
"771645", "Stepnogorsk",
"771134", "Zhympity",
"771147", "Akzhaiksky\ District",
"7877", "Republic\ of\ Adygeya",
"771233", "Ganyushkino",
"772137", "Saran",
"771339", "Komsomolskoye",
"771457", "Dzhangildinsky\ District",
"7487", "Tula",
"772635", "Bauyrzhan\ Mamyshuly",
"772144", "Kiyevka",
"771231", "Akkystau",
"771439", "Torgai",
"772159", "Karaganda\ Region",
"772775", "Esik",
"772536", "Kentau",
"7836", "Republic\ of\ Marij\ El",
"771546", "Talshik",
"772535", "Shardara",
"772776", "Shelek",
"771333", "Kandyagash",
"771844", "Irtyshsky\ District",
"7491", "Ryazan",
"771837", "Aksu",
"7421", "Khabarovsk\ Territory",
"7347", "Republic\ of\ Bashkortostan",
"771041", "Aktau\,\ Zhezkazgan",
"771239", "Makat",
"771545", "Zhambylsky\ District",
"772343", "Terekty",
"771431", "Rudny",
"772834", "Ushtobe",
"77272956", "Talgar",
"772239", "Makanchi",
"772545", "Ikan",
"771343", "Irgiz",
"771834", "Uspenka",
"772431", "Zhalagash",
"7486", "Orel",
"7411", "Republic\ of\ Sakha",
"7812", "St\ Petersburg",
"77185", "Shaldai",
"7345", "Tyumen",
"733", "Baikonur",
"772837", "Kabanbai",
"771031", "Aksu\-Ayuly",
"771535", "Novoishimski",
"772333", "Samarskoye",
"771441", "Karabalyk",
"7820", "Cherepovets",
"771449", "Taranovskoye",
"772546", "Sholakkorgan",
"771039", "Priozersk",
"7879", "Mineranye\ Vody",
"771536", "Taiynsha",
"7814", "Republic\ of\ Karelia",
"7841", "Penza",
"7383", "Novosibirsk",
"772439", "Aralsky\ District",
"7302", "Chita",
"771539", "Beskol",
"771633", "Ereimentau",
"772842", "Kogaly",
"772436", "Terenozek",
"772830", "Alakolsky\ District",
"772643", "Shu",
"7817", "Vologda",
"771832", "Irtyshsk",
"771446", "Uzunkolsky\ District",
"771840", "Bayanaul",
"771036", "Balkhash",
"772541", "Myrzakent",
"772138", "Gabidena\ Mustafina",
"7717", "Astana",
"772435", "Zhanakorgan",
"771458", "Kostanai\ Region",
"772236", "Beskaragai",
"7391", "Krasnoyarsk\ Territory",
"771035", "Ulytau",
"7833", "Kirov",
"771531", "Bulayevo",
"77112", "Uralsk",
"771445", "Ubaganskoye",
"772531", "Aksukent",
"772148", "Molodezhnoye",
"77212", "Karaganda",
"771236", "Makhambet",
"7351", "Chelyabinsk",
"772779", "Narynkol",
"77106", "Satpaev",
"771541", "Mamlutka",
"771138", "Zhalpaktal",
"771435", "Zhitikara",
"7861", "Krasnodar\ Territory",
"771235", "Dossor",
"7342", "Perm",
"771643", "Atbasar",
"7855", "Naberezhnye\ Chelny",
"772771", "Kaskelen",
"772840", "Saryozek",
"7483", "Bryansk",
"772832", "Zhansugurov",
"772633", "Asa",
"7815", "Murmansk",
"771842", "Koktobe",
"771436", "Taranovskoye",
"772156", "Shakhtinsk",
"772539", "Kazygurt",
"7873", "Ingushi\ Republic",
"77273", "Almaty",
"7385", "Altai\ Territory",
"772838", "Balpyk\ bi",
"772252", "Karaul",
"771336", "Khromtau",
"772773", "Bakanas",
"771641", "Astrakhanka",
"77182", "Pavlodar",
"7484", "Kaluga",
"772346", "Aksuat",
"772631", "Kulan",
"7482", "Tver",
"772639", "Saudakent",
"7343", "Ekaterinburg",
"772931", "Shetpe",
"7816", "Veliky\ Novgorod",
"772533", "Turkestan",
"771335", "Shalkar",
"7872", "Republic\ of\ Daghestan",
"771132", "Fyodorovka",
"771543", "Yavlenka",
"7471", "Kursk",
"772345", "Shar",
"771140", "Saikhin",
"771649", "Zhaksynsky\ District",
"771452", "Karasu",
"7834", "Republic\ of\ Mordovia",
"772132", "Nurinsky\ District",
"772543", "Aqsumbe",
"771345", "Karauylkeldy",
"771130", "Peremetnoye",
"771533", "Saumalkol",
"771142", "Taipak",
"772335", "Zyryanovsk",
"771639", "Stepnyak",
"77274", "Karassaisky\ District",
"772757", "Akshi",
"771346", "Shubarkuduk",
"771631", "Shortandy",
"77282", "Taldykorgan",
"771838", "Koktobe",
"772336", "Ridder",
"772641", "Akkol",
"7846", "Samara",
"772836", "Karabulak",
"7353", "Orenburg",
"771030", "Atasu",
"771042", "Zharyk",
"771440", "Amangeldy",
"77232", "Ust\-Kamenogorsk",
"7474", "Lipetsk",
"772348", "Kokpekty",
"772774", "Talgar",
"7871", "Chechen\ Republic",
"7472", "Belgorod",
"771232", "Atyrau\ Region",
"771537", "Timiryazevo",
"772835", "Tekeli",
"771544", "Presnovka",
"771845", "Pavlodar\ Area",
"7481", "Smolensk",
"772534", "Zhetysai",
"7863", "Rostov",
"7416", "Amur\ Region",
"772230", "Urdzhar",
"77272983", "Kaskelen",
"771651", "Kabanbai\ Batyr",
"772547", "Lenger",
"771230", "Atyrau\ Region",
"771547", "Zhambylsky\ District",
"7426", "Jewish\ Autonomous\ Region",
"740", "Kaliningrad",
"771534", "Sergeyevka",
"772725", "Otegen\ Batyra",
"772544", "Shaulder",
"7496", "Moscow",
"772537", "Saryagash",
"7499", "Moscow",
"772432", "Shiyeli",
"77132", "Aktobe\/Kargalinskoye",
"771348", "Shalkarsky\ District",
"7831", "Nizhni\ Novgorod",
"77149", "Kostanai",
"771032", "Karazhal",
"771040", "Zhairem\ \(GOK\)",
"772777", "Kegen",
"771442", "Fyodorovka",
"771836", "Sharbakty",
"771430", "Arkalyk",
"772338", "Bozanbai\/Molodezhnyi",
"7878", "Karachayevo\-Cherkessian\ Republic",
"772637", "Sarykemer",
"7495", "Moscow",
"771455", "Zatobolsk",
"772644", "Karatau",
"771342", "Badamsha",
"771330", "Khromtau\ District",
"772438", "Aiteke\ bi",
"771145", "Karatobe\ District",
"772332", "Shemonaikha",
"772340", "Zaisan",
"77142", "Kostanai",
"771448", "Oktyabrskoye",
"771647", "Esil",
"7394", "Republic\ of\ Tuva",
"771038", "Shashubai",
"771456", "Kachar",
"77122", "Atyrau",
"7847", "Republic\ of\ Kalmykia",
"772937", "Kuryk",
"771146", "Akzhaiksky\ District",
"772146", "Karkaralinsk",
"772759", "Almaty\ Region",
"771238", "Miyaly",
"772934", "Zhanaozen",
"77222", "Semey",
"771136", "Chapayev",
"7845", "Saratov",
"7712302", "Tengizshevroil",
"7352", "Kurgan",
"7415", "Kamchatka\ Region",
"771340", "Khobdinsky\ District",
"772256", "Kainar",
"77242", "Kyzylorda",
"772634", "Zhanatas",
"7473", "Voronezh",
"771332", "Uil",
"7390", "Republic\ of\ Khakassia",
"772330", "Zyryanovsky\ District",
"771135", "Zhanibek",
"771644", "Arshaly",
"7862", "Sochi",
"772342", "Katon\-Karagai",
"771438", "Amangeldy",
"77102", "Zhezkazgan",
"771637", "Korgalzhyn",
"7341", "Udmurtian\ Republic",
"7427", "Chukotka\ Autonomous\ District",};
$areanames{ru} = {"772159", "Карагандинская\ область",
"772536", "Кентау",
"772775", "Енбекшиказахский\ р\-н",
"771231", "Исатайский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"771546", "Акжарский\ р\-н",
"771837", "Аксуский\ р\-н",
"7491", "Рязанская\ обл\.",
"771333", "Мугалжарский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"772535", "Шардара",
"771844", "Иртышский\ р\-н",
"772343", "Курчумский\ р\-н",
"771545", "Жамбылский\ р\-н",
"771239", "Макатский\ р\-н",
"771431", "Рудный",
"772834", "Каратальский\ р\-н",
"77272956", "Талгар",
"7421", "Хабаровский\ край",
"771041", "Актау\,\ Жезказган",
"7347", "Республика\ Башкортостан",
"7411", "Республика\ Саха\ \/Якутия\/",
"77185", "Шалдай",
"7812", "г\.\ Санкт\-Петербург",
"771343", "Иргизский\ р\-н",
"772545", "Икан",
"772239", "Урджарский\ р\-н",
"7486", "Орловская\ обл\.",
"771834", "Успенский\ р\-н",
"772431", "Жалагашский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771441", "Карабалыкский\ р\-н",
"7345", "Тюменская\ обл\.",
"733", "Байконыр",
"772837", "Алакольский\ р\-н",
"771031", "Шетский\ р\-н",
"772546", "Шолаккорган",
"771039", "Приозерск",
"7879", "Ставропольский\ край",
"7820", "Вологодская\ обл\.",
"771449", "Тарановский\ р\-н",
"7302", "Забайкальский\ край",
"772439", "Аральский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"7814", "Республика\ Карелия",
"7383", "Новосибирская\ обл\.",
"7841", "Пензенская\ обл\.",
"772339", "Курчумский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"7498", "Московская\ обл\.",
"7813", "Ленинградская\ обл\.",
"771144", "Казталовский\ р\-н",
"771635", "Жаксынский\ р\-н",
"7384", "Кемеровская\ обл\.",
"7485", "Ярославская\ обл\.",
"771454", "Наурзумский\ р\-н",
"771349", "Шалкарский\ р\-н",
"772147", "Каркаралинский\ р\-н",
"772433", "Аральский\ р\-н",
"771636", "Щучинский\ р\-н",
"771341", "Хобдинский\ р\-н",
"77145834", "Красногорск",
"771033", "Шетский\ р\-н",
"7382", "Томская\ обл\.",
"772257", "Шульбинск",
"77224", "Эмельтау",
"771443", "Мендыкаринский\ р\-н",
"7349", "Ямало\-Ненецкий\ АО",
"772331", "Глубоковский\ р\-н",
"771646", "Буландинский\ р\-н",
"771331", "Мартукский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"772935", "Каракиянский\ р\-н",
"772752", "Илийский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"772153", "Абайский\ р\-н",
"771433", "Лисаковск",
"772636", "Кордай",
"7848", "Самарская\ обл\.",
"772341", "Катон\-Карагайский\ р\-н",
"771147", "Акжаикский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"7877", "Республика\ Адыгея",
"771134", "Сырымский\ р\-н",
"771645", "Степногорск",
"771457", "Джангильдинский\ р\-н",
"7487", "Тульская\ обл\.",
"772144", "Нуринский\ р\-н",
"772635", "Жуалынский\ р\-н",
"772137", "Сарань",
"771339", "Айтекебийский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"77292", "Актау",
"771453", "Аулиекольский\ р\-н",
"7712303", "Тензиз",
"772542", "Асыката",
"772530", "Темирлановка",
"771143", "Теректинский\ р\-н",
"771532", "Аккайынский\ р\-н",
"7475", "Тамбовская\ обл\.",
"771540", "Уалихановский\ р\-н",
"771237", "Жылыойский\ р\-н",
"7413", "Магаданская\ обл\.",
"7866", "Республика\ Кабардино\-Балкарская",
"7843", "Республика\ Татарстан",
"772841", "Аксуский\ р\-н",
"7381", "Омская\ обл\.",
"771444", "Узункольский\ р\-н",
"772770", "Жамбылский\ р\-н",
"7869", "г\.\ Севастополь",
"771638", "Аккольский\ р\-н",
"771437", "Камыстинский\ р\-н",
"771034", "Улытауский\ р\-н",
"77245", "Кызылординская\ область",
"77262", "Тараз",
"771831", "Железинский\ р\-н",
"771434", "Денисовский\ р\-н",
"772831", "Панфиловский\ р\-н",
"771037", "Актогайский\ р\-н",
"77162", "Кокшетау",
"771648", "Жаркаинский\ р\-н",
"77213", "Темиртау",
"772772", "Капчагай",
"771447", "Карабалыкский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"771841", "Актогайский\ р\-н",
"772638", "Шуский\ р\-н",
"736", "Республика\ Крым",
"772938", "Тупкараганский\ р\-н",
"772351", "Бородулихинский\ р\-н",
"7423", "Приморский\ край",
"772540", "Арыс",
"772237", "Аязог",
"772532", "Абая",
"7818", "Архангельская\ обл\.",
"77125", "Атырауская\ область",
"771542", "Уалихановский\ р\-н",
"771133", "Бурлинский\ р\-н",
"7493", "Ивановская\ обл\.",
"77279", "Алматы",
"772839", "Саркандский\ р\-н",
"771234", "Индерский\ р\-н",
"77272", "Алма\-Ата",
"7388", "Республика\ Алтай",
"772538", "имени\ Турара\ Рыскулова",
"772353", "Бородулихинский\ р\-н",
"7494", "Костромская\ обл\.",
"772932", "Бейнеуский\ р\-н",
"7395", "Иркутская\ обл\.",
"7424", "Сахалинская\ обл\.",
"771131", "Зеленовский\ р\-н",
"77152", "Петропавловск",
"771139", "Таскалинский\ р\-н",
"772337", "Серебрянск",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"772344", "Тарбагатайский\ р\-н",
"772778", "Уйгурский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771630", "Боровое",
"772251", "Курчатов",
"772833", "Алакольский\ р\-н",
"7821", "Республика\ Коми",
"771334", "Мугалжарский\ р\-н",
"772632", "Меркенский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"771843", "Майский\ р\-н",
"7492", "Владимирская\ обл\.",
"772149", "Осакаровский\ р\-н",
"77135", "Актюбинская\ область",
"771347", "Айтекебийский\ р\-н",
"772347", "Жарминский\ р\-н",
"771149", "Акжаикский\ р\-н",
"7865", "Ставропольский\ край",
"771640", "Сандыктауский\ р\-н",
"772334", "Уланский\ р\-н",
"7851", "Астраханская\ обл\.",
"771632", "Зерендинский\ р\-н",
"772843", "Лепсы",
"77187", "Экибастуз",
"7844", "Волгоградская\ обл\.",
"772642", "Мойынкумский\ р\-н",
"771459", "Костанайская\ область",
"7811", "Псковская\ обл\.",
"771833", "Качирский\ р\-н",
"771337", "Алгинский\ р\-н",
"772548", "Шаян",
"772131", "Абайский\ р\-н",
"7301", "Республика\ Бурятия",
"77252", "Шымкент",
"7842", "Ульяновская\ обл\.",
"771451", "Сарыкольский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"771141", "Жангалинский\ р\-н",
"771342", "Каргалинский\ р\-н",
"772644", "Таласский\ р\-н",
"771330", "Хромтауский\ р\-н",
"772438", "Казалинский\ р\-н",
"772637", "Байзакский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"771455", "Костанайский\ р\-н",
"7495", "Московская\ обл\.",
"771647", "Есильский\ р\-н",
"7394", "Республика\ Тыва",
"771038", "Сыры\-Шаган",
"772332", "Шемонаихинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"77142", "Костанай",
"772340", "Зайсанский\ р\-н",
"771448", "Карасуский\ р\-н",
"77122", "Атырау",
"771456", "Качар",
"7847", "Республика\ Калмыкия",
"771146", "Акжаикский\ р\-н",
"772937", "Каракиянский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"772146", "Каркаралинск",
"772759", "Алматинская\ область",
"771136", "Акжаикский\ р\-н",
"7712302", "Тенгизшевройл",
"7845", "Саратовская\ обл\.",
"7352", "Курганская\ обл\.",
"772934", "Жанаозен",
"77222", "Семипалатинск",
"77242", "Кызылорда",
"772256", "Алгабас",
"771340", "Хобдинский\ р\-н",
"7473", "Воронежская\ обл\.",
"771332", "Уилский\ р\-н",
"772634", "Жанатас",
"7415", "Камчатский\ край",
"7341", "Республика\ Удмуртская",
"771637", "Коргалжынский\ р\-н",
"77102", "Жезказган",
"7427", "Чукотский\ АО",
"7390", "Республика\ Хакасия",
"772330", "Зыряновский\ р\-н",
"772342", "Катон\-Карагайский\ р\-н",
"7862", "Краснодарский\ край",
"771135", "Жанибекский\ р\-н",
"771644", "Аршалынский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"7846", "Самарская\ обл\.",
"77232", "Усть\-Каменогорск",
"771440", "Амангельдинский\ р\-н",
"7474", "Липецкая\ обл\.",
"772774", "Талгарский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"7353", "Оренбургская\ обл\.",
"771042", "Акой",
"772835", "Текели",
"771544", "Жамбылский\ р\-н",
"7871", "Республика\ Чеченская",
"771232", "Атырауская\ область",
"7472", "Белгородская\ обл\.",
"771537", "Тимирязевский\ р\-н",
"7416", "Амурская\ обл\.",
"7863", "Ростовская\ обл\.",
"772547", "Ленгер",
"771651", "Целиноградский\ р\-н",
"772230", "Урджарский\ р\-н",
"77272983", "Каскелен",
"7481", "Смоленская\ обл\.",
"771845", "Павлодар",
"772534", "Жетысай",
"740", "Калининградская\ обл\.",
"771534", "Шал\ Акына\ р\-н",
"772725", "Отеген\-Батыр",
"771547", "Жамбылский\ р\-н",
"771230", "Атырауская\ область",
"7426", "Еврейская\ автономная\ обл\.",
"7496", "г\.\ Москва",
"772537", "Сарыагаш",
"772544", "Шаульдер",
"77149", "Костанай",
"772432", "Шиелийский\ р\-н",
"7499", "г\.\ Москва",
"77132", "Актобе\/Актюбинск",
"771348", "Шалкарский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771836", "Щербактинский\ р\-н",
"771442", "Федоровский\ р\-н",
"771430", "Аркалык",
"772338", "Уланский\ р\-н",
"771032", "Каражал",
"771040", "Жайрем\ \(ГОК\)",
"772777", "Райымбекский\ р\-н",
"77273", "Алма\-Ата",
"7385", "Алтайский\ край",
"772838", "Коксуский\ р\-н",
"772252", "Абайский\ р\-н",
"771641", "Астраханский\ р\-н",
"771336", "Хромтауский\ р\-н",
"772773", "Балхашский\ р\-н",
"77182", "Павлодар",
"772631", "Турара\ Рыскулова\ р\-н",
"7484", "Калужская\ обл\.",
"772346", "Тарбагатайский\ р\-н",
"7816", "Новгородская\ обл\.",
"771335", "Шалкарский\ р\-н",
"772533", "Туркестан",
"7482", "Тверская\ обл\.",
"772639", "Сарысуский\ р\-н",
"772931", "Мангистауский\ р\-н",
"7343", "Свердловская\ обл",
"771649", "Жаксынский\ р\-н",
"7872", "Республика\ Дагестан",
"772345", "Жарминский\ р\-н",
"771132", "Теректинский\ р\-н",
"771543", "Есильский\ р\-н",
"7471", "Курская\ обл\.",
"771140", "Бокейординский\ р\-н",
"7834", "Республика\ Мордовия",
"771345", "Байганинский\ р\-н",
"772543", "Аксумбе",
"772132", "Нуринский\ р\-н",
"771452", "Карасуский\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"771130", "Зеленовский\ р\-н",
"772335", "Зыряновск",
"771142", "Акжаикский\ р\-н",
"771533", "Айыртауский\ р\-н",
"772757", "Акший",
"77274", "Карасайский\ р\-н",
"771631", "Шортандинский\ р\-н",
"771346", "Темирский\ р\-н",
"77282", "Талдыкорган",
"771838", "Майский\ р\-он",
"772641", "Таласский\ р\-н",
"772336", "Риддер",
"771633", "Ерейментауский\ р\-н",
"772842", "Кербулакский\ р\-н",
"772436", "Сырдарьинский\ р\-н",
"772830", "Алакольский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"771036", "Балхаш",
"7817", "Вологодская\ обл\.",
"772643", "Шуский\ р\-н",
"771832", "Иртышский\ р\-н",
"771446", "Узункольский\ р\-н",
"771840", "Баянаульский\ р\-н",
"771458", "Костанайская\ область",
"772138", "Бухар\-Жырауский\ р\-н",
"772541", "Мырзакент",
"7717", "Астана",
"772435", "Жанакорганский\ р\-н",
"7833", "Кировская\ обл\.",
"771531", "Магжана\ Жумабаева\ р\-н",
"77112", "Уральск",
"771445", "Алтынсаринский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"7391", "Красноярский\ край",
"771035", "Улытауский\ р\-н",
"771236", "Махамбетский\ р\-н",
"7351", "Челябинская\ обл\.",
"772531", "Аксукент",
"772148", "Осакаровский\ р\-н",
"77212", "Караганда",
"771541", "Мамлютский\ р\-н",
"771138", "Казталовский\ р\-н",
"771435", "Житикаринский\ р\-н",
"772779", "Райымбекский\ р\-н",
"77106", "Сатпаев",
"7342", "Пермский\ край",
"772771", "Карасайский\ р\-н",
"7855", "Республика\ Татарстан",
"771643", "Атбасарский\ р\-н",
"772840", "Кербулакский\ р\-н",
"772832", "Аксуский\ р\-н",
"7483", "Брянская\ обл\.",
"771235", "Макатский\ р\-н",
"7861", "Краснодарский\ край",
"772156", "Шахтинск",
"772539", "Казыгурт",
"7873", "Республика\ Ингушетия",
"772633", "Жамбылский\ р\-н",
"7815", "Мурманская\ обл\.",
"771436", "Тарановский\ р\-н",
"771842", "Майский\ р\-он",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;