/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;

public class ZoneInfoFile {
    public static final byte[] JAVAZI_LABEL = new byte[]{106, 97, 118, 97, 122, 105, 0};
    private static final int JAVAZI_LABEL_LENGTH = JAVAZI_LABEL.length;
    public static final byte JAVAZI_VERSION = 1;
    public static final byte TAG_RawOffset = 1;
    public static final byte TAG_LastDSTSaving = 2;
    public static final byte TAG_CRC32 = 3;
    public static final byte TAG_Transition = 4;
    public static final byte TAG_Offset = 5;
    public static final byte TAG_SimpleTimeZone = 6;
    public static final byte TAG_GMTOffsetWillChange = 7;
    public static final String JAVAZM_FILE_NAME = "ZoneInfoMappings";
    public static final byte[] JAVAZM_LABEL = new byte[]{106, 97, 118, 97, 122, 109, 0};
    private static final int JAVAZM_LABEL_LENGTH = JAVAZM_LABEL.length;
    public static final byte JAVAZM_VERSION = 1;
    public static final byte TAG_ZoneIDs = 64;
    public static final byte TAG_RawOffsets = 65;
    public static final byte TAG_RawOffsetIndices = 66;
    public static final byte TAG_ZoneAliases = 67;
    public static final byte TAG_TZDataVersion = 68;
    private static HashMap zoneInfoObjects = null;
    private static SoftReference zoneIDs = null;
    private static SoftReference rawOffsetIndices = null;
    private static SoftReference rawOffsets = null;
    private static SoftReference zoneInfoMappings = null;

    public static String getFileName(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneInfo getCustomTimeZone(String string, int n) {
        ZoneInfo zoneInfo;
        int n2;
        char c;
        if (n >= 0) {
            c = '+';
            n2 = n;
        } else {
            c = '-';
            n2 = -n;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        StringBuffer stringBuffer = new StringBuffer("GMT");
        stringBuffer.append(c);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3).append(':');
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        String string2 = stringBuffer.toString();
        Class clazz = ZoneInfoFile.class;
        synchronized (clazz) {
            if (zoneInfoObjects == null) {
                zoneInfoObjects = new HashMap();
            }
            if ((zoneInfo = (ZoneInfo)zoneInfoObjects.get(string2)) == null) {
                zoneInfo = new ZoneInfo(string2, n * 60000);
                zoneInfoObjects.put(string2, zoneInfo);
                if (!string2.equals(string)) {
                    zoneInfoObjects.put(string, zoneInfo);
                }
            }
        }
        return (ZoneInfo)zoneInfo.clone();
    }

    public static synchronized ZoneInfo getZoneInfo(String string) {
        ZoneInfo zoneInfo = null;
        if (zoneInfoObjects == null) {
            zoneInfo = ZoneInfoFile.createZoneInfo(string);
            if (zoneInfo != null) {
                zoneInfoObjects = new HashMap();
                zoneInfoObjects.put(string, zoneInfo);
                return (ZoneInfo)zoneInfo.clone();
            }
            return null;
        }
        zoneInfo = (ZoneInfo)zoneInfoObjects.get(string);
        if (zoneInfo != null) {
            return (ZoneInfo)zoneInfo.clone();
        }
        zoneInfo = ZoneInfoFile.createZoneInfo(string);
        if (zoneInfo != null) {
            zoneInfoObjects.put(string, zoneInfo);
            return (ZoneInfo)zoneInfo.clone();
        }
        return null;
    }

    private static ZoneInfo createZoneInfo(String string) {
        int n;
        byte[] byArray = ZoneInfoFile.readZoneInfoFile(ZoneInfoFile.getFileName(string));
        if (byArray == null) {
            return null;
        }
        for (n = 0; n < JAVAZI_LABEL.length; ++n) {
            if (byArray[n] == JAVAZI_LABEL[n]) continue;
            System.err.println("ZoneInfo: wrong magic number: " + string);
            return null;
        }
        if (byArray[n++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n - 1] + "): " + string);
            return null;
        }
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        long[] lArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        try {
            block12: while (n < n2) {
                int n6;
                byte by = byArray[n++];
                if (n2 >= n + (n6 = ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF))) {
                    switch (by) {
                        case 3: {
                            int n7 = byArray[n++] & 0xFF;
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n5 = n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            continue block12;
                        }
                        case 2: {
                            int n7 = (short)(byArray[n++] & 0xFF);
                            n7 = (short)((n7 << 8) + (byArray[n++] & 0xFF));
                            n4 = n7 * 1000;
                            continue block12;
                        }
                        case 1: {
                            int n7 = byArray[n++] & 0xFF;
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n3 = n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            continue block12;
                        }
                        case 4: {
                            int n8;
                            int n7 = n6 / 8;
                            lArray = new long[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                long l = byArray[n++] & 0xFF;
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                lArray[n8] = l = (l << 8) + (long)(byArray[n++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 5: {
                            int n8;
                            int n7 = n6 / 4;
                            nArray = new int[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                int n9 = byArray[n++] & 0xFF;
                                n9 = (n9 << 8) + (byArray[n++] & 0xFF);
                                n9 = (n9 << 8) + (byArray[n++] & 0xFF);
                                nArray[n8] = n9 = (n9 << 8) + (byArray[n++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 6: {
                            int n8;
                            if (n6 != 32 && n6 != 40) {
                                System.err.println("ZoneInfo: wrong SimpleTimeZone parameter size");
                                return null;
                            }
                            int n7 = n6 / 4;
                            nArray2 = new int[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                int n10 = byArray[n++] & 0xFF;
                                n10 = (n10 << 8) + (byArray[n++] & 0xFF);
                                n10 = (n10 << 8) + (byArray[n++] & 0xFF);
                                nArray2[n8] = n10 = (n10 << 8) + (byArray[n++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 7: {
                            if (n6 != 1) {
                                System.err.println("ZoneInfo: wrong byte length for TAG_GMTOffsetWillChange");
                            }
                            bl = byArray[n++] == 1;
                            continue block12;
                        }
                    }
                    System.err.println("ZoneInfo: unknown tag < " + by + ">. ignored.");
                    n += n6;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("ZoneInfo: corrupted zoneinfo file: " + string);
            return null;
        }
        if (n != n2) {
            System.err.println("ZoneInfo: wrong file size: " + string);
            return null;
        }
        return new ZoneInfo(string, n3, n4, n5, lArray, nArray, nArray2, bl);
    }

    static String[] getZoneIDs() {
        String[] stringArray;
        block8: {
            stringArray = null;
            if (zoneIDs != null && (stringArray = (String[])zoneIDs.get()) != null) {
                return stringArray;
            }
            byte[] byArray = null;
            byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = JAVAZM_LABEL_LENGTH + 1;
            int n2 = byArray.length;
            try {
                while (n < n2) {
                    byte by = byArray[n++];
                    int n3 = ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
                    switch (by) {
                        case 64: {
                            int n4 = (byArray[n++] << 8) + (byArray[n++] & 0xFF);
                            stringArray = new String[n4];
                            for (int i = 0; i < n4; ++i) {
                                byte by2 = byArray[n++];
                                stringArray[i] = new String(byArray, n, by2, "US-ASCII");
                                n += by2;
                            }
                            break block8;
                        }
                        default: {
                            n += n3;
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        zoneIDs = new SoftReference(stringArray);
        return stringArray;
    }

    static HashMap getZoneAliases() {
        HashMap hashMap;
        block7: {
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = JAVAZM_LABEL_LENGTH + 1;
            int n2 = byArray.length;
            hashMap = null;
            try {
                while (n < n2) {
                    byte by = byArray[n++];
                    int n3 = ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
                    switch (by) {
                        case 67: {
                            int n4 = (byArray[n++] << 8) + (byArray[n++] & 0xFF);
                            hashMap = new HashMap(n4);
                            for (int i = 0; i < n4; ++i) {
                                byte by2 = byArray[n++];
                                String string = new String(byArray, n, by2, "US-ASCII");
                                n += by2;
                                by2 = byArray[n++];
                                String string2 = new String(byArray, n, by2, "US-ASCII");
                                n += by2;
                                hashMap.put(string, string2);
                            }
                            break block7;
                        }
                        default: {
                            n += n3;
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        return hashMap;
    }

    static byte[] getRawOffsetIndices() {
        byte[] byArray;
        block8: {
            byArray = null;
            if (rawOffsetIndices != null && (byArray = (byte[])rawOffsetIndices.get()) != null) {
                return byArray;
            }
            byte[] byArray2 = ZoneInfoFile.getZoneInfoMappings();
            int n = JAVAZM_LABEL_LENGTH + 1;
            int n2 = byArray2.length;
            try {
                while (n < n2) {
                    byte by = byArray2[n++];
                    int n3 = ((byArray2[n++] & 0xFF) << 8) + (byArray2[n++] & 0xFF);
                    switch (by) {
                        case 66: {
                            byArray = new byte[n3];
                            for (int i = 0; i < n3; ++i) {
                                byArray[i] = byArray2[n++];
                            }
                            break block8;
                        }
                        default: {
                            n += n3;
                            break;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsetIndices = new SoftReference(byArray);
        return byArray;
    }

    static int[] getRawOffsets() {
        int[] nArray;
        block8: {
            nArray = null;
            if (rawOffsets != null && (nArray = (int[])rawOffsets.get()) != null) {
                return nArray;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = JAVAZM_LABEL_LENGTH + 1;
            int n2 = byArray.length;
            try {
                while (n < n2) {
                    byte by = byArray[n++];
                    int n3 = ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
                    switch (by) {
                        case 65: {
                            int n4 = n3 / 4;
                            nArray = new int[n4];
                            for (int i = 0; i < n4; ++i) {
                                int n5 = byArray[n++] & 0xFF;
                                n5 = (n5 << 8) + (byArray[n++] & 0xFF);
                                n5 = (n5 << 8) + (byArray[n++] & 0xFF);
                                nArray[i] = n5 = (n5 << 8) + (byArray[n++] & 0xFF);
                            }
                            break block8;
                        }
                        default: {
                            n += n3;
                            break;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsets = new SoftReference(nArray);
        return nArray;
    }

    private static byte[] getZoneInfoMappings() {
        int n;
        byte[] byArray;
        if (zoneInfoMappings != null && (byArray = (byte[])zoneInfoMappings.get()) != null) {
            return byArray;
        }
        byArray = ZoneInfoFile.readZoneInfoFile(JAVAZM_FILE_NAME);
        if (byArray == null) {
            return null;
        }
        for (n = 0; n < JAVAZM_LABEL.length; ++n) {
            if (byArray[n] == JAVAZM_LABEL[n]) continue;
            System.err.println("ZoneInfo: wrong magic number: ZoneInfoMappings");
            return null;
        }
        if (byArray[n++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n - 1] + "): " + JAVAZM_FILE_NAME);
            return null;
        }
        zoneInfoMappings = new SoftReference(byArray);
        return byArray;
    }

    private static byte[] readZoneInfoFile(String string) {
        byte[] byArray;
        block2: {
            byArray = null;
            try {
                String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
                final String string3 = string2 + File.separator + "lib" + File.separator + "zi" + File.separator + string;
                byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File file = new File(string3);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        int n = (int)file.length();
                        byte[] byArray = new byte[n];
                        if (fileInputStream.read(byArray) != n) {
                            fileInputStream.close();
                            throw new IOException("read error on " + string3);
                        }
                        fileInputStream.close();
                        return byArray;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof FileNotFoundException && !JAVAZM_FILE_NAME.equals(string)) break block2;
                System.err.println("ZoneInfo: " + exception.getMessage());
            }
        }
        return byArray;
    }
}

