package org.jboss.cache.notifications.event;

import org.jboss.cache.Cache;

/**
 * An interface that defines common characteristics of events
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
public interface Event
{
   static enum Type
   {
      CACHE_STARTED, CACHE_STOPPED, CACHE_BLOCKED, CACHE_UNBLOCKED, NODE_ACTIVATED, NODE_PASSIVATED,
      NODE_LOADED, NODE_EVICTED, NODE_CREATED, NODE_REMOVED, NODE_MODIFIED, NODE_MOVED, NODE_VISITED,
      TRANSACTION_COMPLETED, TRANSACTION_REGISTERED, VIEW_CHANGED, BUDDY_GROUP_CHANGED
   }

   /**
    * @return the type of event represented by this instance.
    */
   Type getType();

   /**
    * @return true if the notification is before the event has occured, false if after the event has occured.
    */
   boolean isPre();

   /**
    * @return a handle to the cache instance that generated this notification.
    */
   Cache getCache();
}
