/* DbTable.c generated by valac 0.20.1, the Vala compiler
 * generated from DbTable.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 *
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gboolean (*compatible) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gboolean (*equivalent) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gchar* (*to_string) (GdaDataDbFieldInfo* self);
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	void (*copy) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	gboolean (*equal) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	gboolean (*compatible) (GdaDataDbTable* self, GdaDataDbTable* table);
	gboolean (*equivalent) (GdaDataDbTable* self, GdaDataDbTable* table);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

typedef enum  {
	GDA_DATA_DB_TABLE_ERROR_READ_ONLY,
	GDA_DATA_DB_TABLE_ERROR_FIELD
} GdaDataDbTableError;
#define GDA_DATA_DB_TABLE_ERROR gda_data_db_table_error_quark ()


GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value, gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value, gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GdaDataDbTableTableType gda_data_db_table_table_type_from_string (const gchar* str);
void gda_data_db_table_set_field (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
GdaDataDbFieldInfo* gda_data_db_table_get_field (GdaDataDbTable* self, const gchar* name, GError** error);
gboolean gda_data_db_table_compatible (GdaDataDbTable* self, GdaDataDbTable* table);
static gboolean gda_data_db_table_real_compatible (GdaDataDbTable* self, GdaDataDbTable* table);
GeeCollection* gda_data_db_table_get_fields (GdaDataDbTable* self);
const gchar* gda_data_db_field_info_get_name (GdaDataDbFieldInfo* self);
gboolean gda_data_db_field_info_compatible (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
gboolean gda_data_db_table_equivalent (GdaDataDbTable* self, GdaDataDbTable* table);
static gboolean gda_data_db_table_real_equivalent (GdaDataDbTable* self, GdaDataDbTable* table);
gboolean gda_data_db_field_info_equivalent (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
GdaDataDbCatalog* gda_data_db_table_get_catalog (GdaDataDbTable* self);
void gda_data_db_table_set_catalog (GdaDataDbTable* self, GdaDataDbCatalog* value);
GdaDataDbSchema* gda_data_db_table_get_schema (GdaDataDbTable* self);
void gda_data_db_table_set_schema (GdaDataDbTable* self, GdaDataDbSchema* value);
GdaDataDbTableTableType gda_data_db_table_get_table_type (GdaDataDbTable* self);
void gda_data_db_table_set_table_type (GdaDataDbTable* self, GdaDataDbTableTableType value);
GeeCollection* gda_data_db_table_get_records (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_depends (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_referenced (GdaDataDbTable* self);
GeeCollection* gda_data_db_table_get_primary_keys (GdaDataDbTable* self);
GQuark gda_data_db_table_error_quark (void);


GdaDataDbTableTableType gda_data_db_table_table_type_from_string (const gchar* str) {
	GdaDataDbTableTableType result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "BASE TABLE") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE;
		return result;
	}
	_tmp1_ = str;
	if (g_strcmp0 (_tmp1_, "VIEW") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW;
		return result;
	}
	_tmp2_ = str;
	if (g_strcmp0 (_tmp2_, "LOCAL TEMPORARY") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY;
		return result;
	}
	_tmp3_ = str;
	if (g_strcmp0 (_tmp3_, "SYSTEM TABLE") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE;
		return result;
	}
	_tmp4_ = str;
	if (g_strcmp0 (_tmp4_, "GLOBAL TEMPORARY") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY;
		return result;
	}
	_tmp5_ = str;
	if (g_strcmp0 (_tmp5_, "ALIAS") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS;
		return result;
	}
	_tmp6_ = str;
	if (g_strcmp0 (_tmp6_, "SYNONYM") == 0) {
		result = GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM;
		return result;
	}
	result = GDA_DATA_DB_TABLE_TABLE_TYPE_NONE;
	return result;
}


GType gda_data_db_table_table_type_get_type (void) {
	static volatile gsize gda_data_db_table_table_type_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_table_table_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GDA_DATA_DB_TABLE_TABLE_TYPE_NONE, "GDA_DATA_DB_TABLE_TABLE_TYPE_NONE", "none"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE, "GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE", "base-table"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW, "GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW", "view"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY, "GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY", "local-temporary"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE, "GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE", "system-table"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY, "GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY", "global-temporary"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS, "GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS", "alias"}, {GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM, "GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM", "synonym"}, {0, NULL, NULL}};
		GType gda_data_db_table_table_type_type_id;
		gda_data_db_table_table_type_type_id = g_enum_register_static ("GdaDataDbTableTableType", values);
		g_once_init_leave (&gda_data_db_table_table_type_type_id__volatile, gda_data_db_table_table_type_type_id);
	}
	return gda_data_db_table_table_type_type_id__volatile;
}


void gda_data_db_table_set_field (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_TABLE_GET_INTERFACE (self)->set_field (self, field, error);
}


GdaDataDbFieldInfo* gda_data_db_table_get_field (GdaDataDbTable* self, const gchar* name, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_field (self, name, error);
}


static gboolean gda_data_db_table_real_compatible (GdaDataDbTable* self, GdaDataDbTable* table) {
	gboolean result = FALSE;
	g_return_val_if_fail (table != NULL, FALSE);
	{
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _f_it;
		_tmp0_ = gda_data_db_table_get_fields (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_f_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			GdaDataDbFieldInfo* f;
			_tmp5_ = _f_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _f_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			f = (GdaDataDbFieldInfo*) _tmp8_;
			{
				GdaDataDbTable* _tmp9_;
				GeeCollection* _tmp10_;
				GeeCollection* _tmp11_;
				GeeCollection* _tmp12_;
				GeeIterator* _tmp13_ = NULL;
				GeeIterator* _tmp14_;
				GeeIterator* _ft_it;
				_tmp9_ = table;
				_tmp10_ = gda_data_db_table_get_fields (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				_ft_it = _tmp14_;
				while (TRUE) {
					GeeIterator* _tmp15_;
					gboolean _tmp16_ = FALSE;
					GeeIterator* _tmp17_;
					gpointer _tmp18_ = NULL;
					GdaDataDbFieldInfo* ft;
					GdaDataDbFieldInfo* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					GdaDataDbFieldInfo* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp15_ = _ft_it;
					_tmp16_ = gee_iterator_next (_tmp15_);
					if (!_tmp16_) {
						break;
					}
					_tmp17_ = _ft_it;
					_tmp18_ = gee_iterator_get (_tmp17_);
					ft = (GdaDataDbFieldInfo*) _tmp18_;
					_tmp19_ = ft;
					_tmp20_ = gda_data_db_field_info_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = f;
					_tmp23_ = gda_data_db_field_info_get_name (_tmp22_);
					_tmp24_ = _tmp23_;
					if (g_strcmp0 (_tmp21_, _tmp24_) == 0) {
						GdaDataDbFieldInfo* _tmp25_;
						GdaDataDbFieldInfo* _tmp26_;
						gboolean _tmp27_ = FALSE;
						_tmp25_ = f;
						_tmp26_ = ft;
						_tmp27_ = gda_data_db_field_info_compatible (_tmp25_, _tmp26_);
						if (!_tmp27_) {
							result = FALSE;
							_g_object_unref0 (ft);
							_g_object_unref0 (_ft_it);
							_g_object_unref0 (f);
							_g_object_unref0 (_f_it);
							return result;
							_g_object_unref0 (ft);
							break;
						}
					}
					_g_object_unref0 (ft);
				}
				_g_object_unref0 (_ft_it);
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	result = TRUE;
	return result;
}


gboolean gda_data_db_table_compatible (GdaDataDbTable* self, GdaDataDbTable* table) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->compatible (self, table);
}


static gboolean gda_data_db_table_real_equivalent (GdaDataDbTable* self, GdaDataDbTable* table) {
	gboolean result = FALSE;
	g_return_val_if_fail (table != NULL, FALSE);
	{
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _f_it;
		_tmp0_ = gda_data_db_table_get_fields (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_f_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			GdaDataDbFieldInfo* f;
			gboolean found;
			gboolean _tmp28_;
			_tmp5_ = _f_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _f_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			f = (GdaDataDbFieldInfo*) _tmp8_;
			found = FALSE;
			{
				GdaDataDbTable* _tmp9_;
				GeeCollection* _tmp10_;
				GeeCollection* _tmp11_;
				GeeCollection* _tmp12_;
				GeeIterator* _tmp13_ = NULL;
				GeeIterator* _tmp14_;
				GeeIterator* _ft_it;
				_tmp9_ = table;
				_tmp10_ = gda_data_db_table_get_fields (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				_ft_it = _tmp14_;
				while (TRUE) {
					GeeIterator* _tmp15_;
					gboolean _tmp16_ = FALSE;
					GeeIterator* _tmp17_;
					gpointer _tmp18_ = NULL;
					GdaDataDbFieldInfo* ft;
					GdaDataDbFieldInfo* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					GdaDataDbFieldInfo* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp15_ = _ft_it;
					_tmp16_ = gee_iterator_next (_tmp15_);
					if (!_tmp16_) {
						break;
					}
					_tmp17_ = _ft_it;
					_tmp18_ = gee_iterator_get (_tmp17_);
					ft = (GdaDataDbFieldInfo*) _tmp18_;
					_tmp19_ = f;
					_tmp20_ = gda_data_db_field_info_get_name (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = ft;
					_tmp23_ = gda_data_db_field_info_get_name (_tmp22_);
					_tmp24_ = _tmp23_;
					if (g_strcmp0 (_tmp21_, _tmp24_) == 0) {
						GdaDataDbFieldInfo* _tmp25_;
						GdaDataDbFieldInfo* _tmp26_;
						gboolean _tmp27_ = FALSE;
						found = TRUE;
						_tmp25_ = f;
						_tmp26_ = ft;
						_tmp27_ = gda_data_db_field_info_equivalent (_tmp25_, _tmp26_);
						if (!_tmp27_) {
							result = FALSE;
							_g_object_unref0 (ft);
							_g_object_unref0 (_ft_it);
							_g_object_unref0 (f);
							_g_object_unref0 (_f_it);
							return result;
						}
						_g_object_unref0 (ft);
						break;
					}
					_g_object_unref0 (ft);
				}
				_g_object_unref0 (_ft_it);
			}
			_tmp28_ = found;
			if (!_tmp28_) {
				result = FALSE;
				_g_object_unref0 (f);
				_g_object_unref0 (_f_it);
				return result;
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	result = TRUE;
	return result;
}


gboolean gda_data_db_table_equivalent (GdaDataDbTable* self, GdaDataDbTable* table) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->equivalent (self, table);
}


GdaDataDbCatalog* gda_data_db_table_get_catalog (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_catalog (self);
}


void gda_data_db_table_set_catalog (GdaDataDbTable* self, GdaDataDbCatalog* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_TABLE_GET_INTERFACE (self)->set_catalog (self, value);
}


GdaDataDbSchema* gda_data_db_table_get_schema (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_schema (self);
}


void gda_data_db_table_set_schema (GdaDataDbTable* self, GdaDataDbSchema* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_TABLE_GET_INTERFACE (self)->set_schema (self, value);
}


GdaDataDbTableTableType gda_data_db_table_get_table_type (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_table_type (self);
}


void gda_data_db_table_set_table_type (GdaDataDbTable* self, GdaDataDbTableTableType value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_TABLE_GET_INTERFACE (self)->set_table_type (self, value);
}


GeeCollection* gda_data_db_table_get_records (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_records (self);
}


GeeCollection* gda_data_db_table_get_depends (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_depends (self);
}


GeeCollection* gda_data_db_table_get_referenced (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_referenced (self);
}


GeeCollection* gda_data_db_table_get_fields (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_fields (self);
}


GeeCollection* gda_data_db_table_get_primary_keys (GdaDataDbTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_TABLE_GET_INTERFACE (self)->get_primary_keys (self);
}


static void gda_data_db_table_base_init (GdaDataDbTableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("catalog", "catalog", "catalog", GDA_DATA_TYPE_DB_CATALOG, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("schema", "schema", "schema", GDA_DATA_TYPE_DB_SCHEMA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_enum ("table-type", "table-type", "table-type", GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("records", "records", "records", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("depends", "depends", "depends", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("referenced", "referenced", "referenced", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("fields", "fields", "fields", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("primary-keys", "primary-keys", "primary-keys", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->compatible = gda_data_db_table_real_compatible;
		iface->equivalent = gda_data_db_table_real_equivalent;
	}
}


GType gda_data_db_table_get_type (void) {
	static volatile gsize gda_data_db_table_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataDbTableIface), (GBaseInitFunc) gda_data_db_table_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gda_data_db_table_type_id;
		gda_data_db_table_type_id = g_type_register_static (G_TYPE_INTERFACE, "GdaDataDbTable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gda_data_db_table_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gda_data_db_table_type_id, GDA_DATA_TYPE_DB_OBJECT);
		g_type_interface_add_prerequisite (gda_data_db_table_type_id, GDA_DATA_TYPE_DB_NAMED_OBJECT);
		g_once_init_leave (&gda_data_db_table_type_id__volatile, gda_data_db_table_type_id);
	}
	return gda_data_db_table_type_id__volatile;
}


GQuark gda_data_db_table_error_quark (void) {
	return g_quark_from_static_string ("gda_data_db_table_error-quark");
}



