/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.Language;
import gnu.expr.ScopeExp;
import gnu.kawa.util.GeneralHashTable;
import gnu.kawa.util.HashNode;

public class NameLookup
extends GeneralHashTable {
    Language language;

    public NameLookup(Language language) {
        this.language = language;
    }

    public void push(Declaration decl) {
        Object symbol = decl.getSymbol();
        if (symbol == null) {
            return;
        }
        if (++this.num_bindings >= this.table.length) {
            this.rehash();
        }
        int hash = this.hash(symbol);
        HashNode node = this.makeEntry(symbol, hash, decl);
        int index = hash & this.mask;
        node.next = this.table[index];
        this.table[index] = node;
    }

    public boolean pop(Declaration decl) {
        Object symbol = decl.getSymbol();
        if (symbol == null) {
            return false;
        }
        int hash = this.hash(symbol);
        HashNode prev = null;
        int index = hash & this.mask;
        HashNode node = this.table[index];
        while (node != null) {
            HashNode next = node.next;
            if (node.getValue() == decl) {
                if (prev == null) {
                    this.table[index] = next;
                } else {
                    prev.next = next;
                }
                --this.num_bindings;
                return true;
            }
            prev = node;
            node = next;
        }
        return false;
    }

    public void push(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            this.push(decl);
        }
    }

    public void pop(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            this.pop(decl);
        }
    }

    public Declaration lookup(Object symbol, int namespace) {
        int hash = this.hash(symbol);
        int index = hash & this.mask;
        HashNode node = this.table[index];
        while (node != null) {
            Declaration decl = (Declaration)node.getValue();
            if (symbol.equals(decl.getSymbol()) && this.language.hasNamespace(decl, namespace)) {
                return decl;
            }
            node = node.next;
        }
        return null;
    }

    public Declaration lookup(Object symbol, boolean function2) {
        return this.lookup(symbol, function2 ? 2 : 1);
    }
}

