#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Mopi
set -o errexit

###
# Call of the Sea
# send your bug reports to contact@dotslashplay.it
###

script_version=20230709.1

GAME_ID='call-of-the-sea'
GAME_NAME='Call of the Sea'

ARCHIVE_BASE_0='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714).exe'
ARCHIVE_BASE_0_MD5='130e503109c0da8323eabbf07f939b40'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='eefc9fe7a9e45a0b9f84cc9f9f9ea1ab'
ARCHIVE_BASE_0_PART2='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='c2d114836a23671a0483ad1ad97c2912'
ARCHIVE_BASE_0_PART3='setup_call_of_the_sea_1.5.15.0_(64bit)_(48714)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='1b4c240b663134295b223c8c62d3cbf0'
ARCHIVE_BASE_0_SIZE='40000000'
ARCHIVE_BASE_0_VERSION='1.5.15.0-gog48714'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/call_of_the_sea'

UNREALENGINE4_NAME='cots'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
${UNREALENGINE4_NAME}.exe"
CONTENT_GAME_MOVIES_FILES="
${UNREALENGINE4_NAME}/content/movies"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}"

HUGE_FILES_DATA="
${UNREALENGINE4_NAME}/content/paks/${UNREALENGINE4_NAME}-windowsnoeditor.pak"

WINE_DIRECT3D_RENDERER='dxvk'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/${UNREALENGINE4_NAME}/Saved"

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'

PACKAGES_LIST='PKG_BIN PKG_MOVIES PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_MOVIES_ID $PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Install required Microsoft Visual C++ libraries

APP_WINETRICKS="${APP_WINETRICKS:-} vcrun2019"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
