#!/bin/sh

cat << EOF
Format: https://www.debian.org/doc/packaging-manuals/copyright-format/1.0/
Upstream-Name: ./play.it
Upstream-Contact: Antoine Le Gonidec <contact@dotslashplay.it>
Source: https://git.dotslashplay.it/games-adventure
Disclaimer: This package is not part of Debian. It is provided as a convenience
 for integrating non-free games with the users expectations of Debian.
License: BSD-2-Clause

Files: *
Copyright:
EOF

# Extract the list of contributors from the upstream LICENSE file.
sed -E -n -e "s/^Copyright © ([0-9]{4}) (.*)/ \\1-$(date +%Y) \\2/p" LICENSE

cat << EOF
License: BSD-2-Clause

License: BSD-2-Clause
 All rights reserved.
 .
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 .
 1. Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.
 .
 2. Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.
 .
 This software is provided by the copyright holders and contributors "as is"
 and any express or implied warranties, including, but not limited to, the
 implied warranties of merchantability and fitness for a particular purpose
 are disclaimed. In no event shall the copyright holder or contributors be
 liable for any direct, indirect, incidental, special, exemplary, or
 consequential damages (including, but not limited to, procurement of
 substitute goods or services; loss of use, data, or profits; or business
 interruption) however caused and on any theory of liability, whether in
 contract, strict liability, or tort (including negligence or otherwise)
 arising in any way out of the use of this software, even if advised of the
 possibility of such damage.
EOF
